/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateStopIdById
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateStopIdById.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        HashMap<String, Stop> referenceStops = new HashMap<String, Stop>();
        for (Stop stop : reference.getAllStops()) {
            referenceStops.put(stop.getId().getId(), stop);
        }
        ArrayList<Stop> stopsToDelete = new ArrayList<Stop>();
        ArrayList<String> existingStops = new ArrayList<String>();
        String feed = CloudContextService.getLikelyFeedName(dao);
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        String agency = dao.getAllAgencies().iterator().next().getId();
        String name = dao.getAllAgencies().iterator().next().getName();
        for (Stop stop : dao.getAllStops()) {
            if (stop.getMtaStopId() == null) continue;
            if (existingStops.contains(stop.getMtaStopId())) {
                this._log.info("There is another stop with the same mta_id. This stop will be removed: Agency {} {} ATIS stop id: {} MTA stop id: {}", agency, name, stop.getId().getId(), stop.getMtaStopId());
                stopsToDelete.add(stop);
                continue;
            }
            existingStops.add(stop.getMtaStopId());
            Stop refStop = (Stop)referenceStops.get(stop.getMtaStopId());
            if (refStop != null) {
                stop.setName(refStop.getName());
            }
            stop.setId(new AgencyAndId(stop.getId().getAgencyId(), stop.getMtaStopId()));
        }
        es.publishMetric(CloudContextService.getNamespace(), "DuplicateStopCount", "feed", feed, stopsToDelete.size());
        for (Stop stop : stopsToDelete) {
            removeEntityLibrary.removeStop(dao, stop);
        }
    }
}

