/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.DuplicateTrips;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCalendarDatesForDuplicateTrips
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateCalendarDatesForDuplicateTrips.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        void var22_42;
        void var23_49;
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        String agency = dao.getAllTrips().iterator().next().getId().getAgencyId();
        HashMap<String, Object> tripsMap = new HashMap<String, Object>();
        ArrayList<DuplicateTrips> duplicateTripData = new ArrayList<DuplicateTrips>();
        int mtaIdNull = 0;
        for (Trip trip : dao.getAllTrips()) {
            if (trip.getMtaTripId() != null) {
                Object trips;
                if (tripsMap.containsKey(trip.getMtaTripId())) {
                    trips = (ArrayList)tripsMap.get(trip.getMtaTripId());
                    ((ArrayList)trips).add(trip);
                    tripsMap.put(trip.getMtaTripId(), trips);
                    continue;
                }
                trips = new ArrayList();
                ((ArrayList)trips).add(trip);
                tripsMap.put(trip.getMtaTripId(), trips);
                continue;
            }
            this._log.info("trip {} mta_trip_id is null", (Object)trip.getId());
            ++mtaIdNull;
        }
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        HashMap<String, Trip> referenceTrips = new HashMap<String, Trip>();
        for (Trip trip : reference.getAllTrips()) {
            referenceTrips.put(trip.getId().getId(), trip);
        }
        int orStopTimes = dao.getAllStopTimes().size();
        this._log.info("Routes: {} Trips: {} Stops: {} Stop times: {} CalDatess: {} ", dao.getAllRoutes().size(), dao.getAllTrips().size(), dao.getAllStops().size(), dao.getAllStopTimes().size(), dao.getAllCalendarDates().size());
        int countUnique = 0;
        int countCombine = 0;
        int countDoNothing = 0;
        int countToday = 0;
        Iterator entries = tripsMap.entrySet().iterator();
        int service_id = this.getNextServiceId(dao);
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            ArrayList trips = (ArrayList)entry.getValue();
            if (trips.size() > 1) {
                Boolean equals = true;
                block3: for (int i = 0; i < trips.size(); ++i) {
                    for (int j = i + 1; j < trips.size(); ++j) {
                        if (this.stopTimesEqual(dao.getStopTimesForTrip((Trip)trips.get(i)), dao.getStopTimesForTrip((Trip)trips.get(j)))) continue;
                        equals = false;
                        countDoNothing += trips.size();
                        if (!this.checkForServiceToday(trips, dao)) break block3;
                        ++countToday;
                        break block3;
                    }
                }
                if (!equals.booleanValue()) continue;
                DuplicateTrips dup = new DuplicateTrips((String)entry.getKey(), Integer.toString(service_id), trips);
                duplicateTripData.add(dup);
                ++service_id;
                countCombine += trips.size();
                continue;
            }
            Iterator trip = (Trip)trips.get(0);
            ((Trip)((Object)trip)).setId(new AgencyAndId(((Trip)((Object)trip)).getId().getAgencyId(), ((Trip)((Object)trip)).getMtaTripId()));
            ++countUnique;
        }
        this._log.info("Mta_trip_ids: null {}, unique {}, do nothing {}, today {}, combine {}, total {}", mtaIdNull, countUnique, countDoNothing, countToday, countCombine, mtaIdNull + countUnique + countDoNothing + countCombine);
        for (DuplicateTrips dts : duplicateTripData) {
            for (Trip trip : dts.getTrips()) {
                for (ServiceCalendarDate serviceCalendarDate : dao.getCalendarDatesForServiceId(trip.getServiceId())) {
                    dts.addServiceDate(serviceCalendarDate);
                }
            }
        }
        HashMap<String, ArrayList<ServiceCalendarDate>> dateMap = new HashMap<String, ArrayList<ServiceCalendarDate>>();
        int newDates = 0;
        for (DuplicateTrips dts : duplicateTripData) {
            if (dateMap.isEmpty()) {
                dateMap.put(dts.getServiceId(), dts.getDates());
                continue;
            }
            boolean addNewDateMap = true;
            for (Map.Entry entry : dateMap.entrySet()) {
                ArrayList scds = (ArrayList)entry.getValue();
                if (!new HashSet<ServiceCalendarDate>(dts.getDates()).equals(new HashSet(scds))) continue;
                addNewDateMap = false;
                dts.setServiceId((String)entry.getKey());
                break;
            }
            if (!addNewDateMap) continue;
            dateMap.put(dts.getServiceId(), dts.getDates());
            newDates += dts.getDates().size();
        }
        int serviceIds = 0;
        for (Map.Entry calDateId : dateMap.entrySet()) {
            AgencyAndId agencyAndId = new AgencyAndId(agency, (String)calDateId.getKey());
            ArrayList arrayList = (ArrayList)calDateId.getValue();
            for (Object calDate : arrayList) {
                ++serviceIds;
                ServiceCalendarDate newScd = new ServiceCalendarDate();
                newScd.setServiceId(agencyAndId);
                newScd.setDate(((ServiceCalendarDate)calDate).getDate());
                newScd.setExceptionType(((ServiceCalendarDate)calDate).getExceptionType());
                dao.saveOrUpdateEntity(newScd);
            }
        }
        HashMap<String, Trip> tripsUpdated = new HashMap<String, Trip>();
        ArrayList<Trip> tripsToRemove = new ArrayList<Trip>();
        for (DuplicateTrips duplicateTrips : duplicateTripData) {
            AgencyAndId newServiceId = new AgencyAndId(agency, duplicateTrips.getServiceId());
            for (Trip trip : duplicateTrips.getTrips()) {
                trip.setServiceId(newServiceId);
                if (trip.getMtaTripId() == null) continue;
                if (tripsUpdated.containsKey(trip.getMtaTripId())) {
                    tripsToRemove.add(trip);
                    continue;
                }
                tripsUpdated.put(trip.getMtaTripId(), trip);
                trip.setId(new AgencyAndId(trip.getId().getAgencyId(), trip.getMtaTripId()));
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Trip tripToRemove : tripsToRemove) {
            var22_42 += dao.getStopTimesForTrip(tripToRemove).size();
            removeEntityLibrary.removeTrip(dao, tripToRemove);
            ++var23_49;
        }
        this._log.info("Added Service Cal dates: {}, Removed trips: {}, Removed stoptimes: {}", serviceIds, (int)var23_49, (int)var22_42);
        this._log.info("Routes: {} Trips: {} Stops: {} Stop times: {} CalDates: {} ", dao.getAllRoutes().size(), dao.getAllTrips().size(), dao.getAllStops().size(), dao.getAllStopTimes().size(), dao.getAllCalendarDates().size());
    }

    private boolean checkForServiceToday(ArrayList<Trip> trips, GtfsMutableRelationalDao dao) {
        Date today = this.removeTime(new Date());
        if (trips.size() > 2) {
            this._log.info("There are more than two matches for this trip id {}", (Object)trips.get(0).getMtaTripId());
        }
        for (Trip trip : trips) {
            for (ServiceCalendarDate calDate : dao.getCalendarDatesForServiceId(trip.getServiceId())) {
                Date date = this.constructDate(calDate.getDate());
                if (calDate.getExceptionType() != 1 || !date.equals(today)) continue;
                trip.setId(new AgencyAndId(trip.getId().getAgencyId(), trip.getMtaTripId()));
                return true;
            }
        }
        return false;
    }

    private int getNextServiceId(GtfsMutableRelationalDao dao) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (ServiceCalendarDate svcDate : dao.getAllCalendarDates()) {
            if (!this.isInt(svcDate.getServiceId().getId())) continue;
            idList.add(Integer.parseInt(svcDate.getServiceId().getId()));
        }
        return (Integer)Collections.max(idList) + 1;
    }

    private boolean isInt(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private boolean stopTimesEqual(List<StopTime> s1, List<StopTime> s2) {
        if (s1.size() != s2.size()) {
            return false;
        }
        boolean index = false;
        for (int i = 0; i < s1.size(); ++i) {
            if (!s1.get(i).getStop().equals(s2.get(i).getStop())) {
                return false;
            }
            if (s1.get(i).getDepartureTime() != s2.get(i).getDepartureTime()) {
                return false;
            }
            if (s1.get(i).getArrivalTime() == s2.get(i).getArrivalTime()) continue;
            return false;
        }
        return true;
    }

    private Date constructDate(ServiceDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, date.getYear());
        calendar.set(2, date.getMonth() - 1);
        calendar.set(5, date.getDay());
        Date date1 = calendar.getTime();
        date1 = this.removeTime(date1);
        return date1;
    }

    private Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }
}

