/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.onebusaway.csv_entities.schema.EnumFieldMappingFactory;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.util.PathwayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StationComplexStrategy
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(StationComplexStrategy.class);
    private static final String STOP_SEPARATOR = " ";
    private String complexFile;
    @CsvField(optional=true)
    private int genericPathwayTraversalTime = 60;
    @CsvField(ignore=true, mapping=EnumFieldMappingFactory.class)
    private Type typeInternal = Type.PATHWAYS;
    @CsvField(optional=true, mapping=EnumFieldMappingFactory.class)
    private PathwayType pathwayType = PathwayType.MODE_STAIRS;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        File stComplexFile = new File(this.complexFile);
        if (!stComplexFile.exists()) {
            throw new IllegalStateException("Station Complex file does not exist: " + stComplexFile.getName());
        }
        Collection<List<Stop>> complexes = this.getComplexList(dao);
        if (this.typeInternal.equals((Object)Type.PATHWAYS)) {
            this.makePathways(complexes, dao);
        } else if (this.typeInternal.equals((Object)Type.PARENT_STATION)) {
            this.setParents(complexes, dao);
        }
    }

    private void setParents(Collection<List<Stop>> complexes, GtfsMutableRelationalDao dao) {
        for (List<Stop> complex : complexes) {
            Map<String, List<Stop>> grouped = complex.stream().collect(Collectors.groupingBy(Stop::getName));
            for (List<Stop> group : grouped.values()) {
                String parent = group.get(0).getParentStation();
                for (Stop stop : group) {
                    stop.setParentStation(parent);
                    dao.updateEntity(stop);
                }
            }
        }
    }

    private void makePathways(Collection<List<Stop>> complexes, GtfsMutableRelationalDao dao) {
        String feedId = dao.getAllStops().iterator().next().getId().getAgencyId();
        ArrayList<Pathway> newPathways = new ArrayList<Pathway>();
        PathwayUtil util = new PathwayUtil(feedId, newPathways);
        for (List<Stop> complex : complexes) {
            for (Stop s : complex) {
                for (Stop t : complex) {
                    if (s != null && s.getParentStation() != null && t != null) {
                        if (s.equals(t)) continue;
                        String id = String.format("complex-%s-%s-%s", this.pathwayType.name(), s.getId().getId(), t.getId().getId());
                        util.createPathway(s, t, this.pathwayType.ordinal(), this.genericPathwayTraversalTime, id, null);
                        continue;
                    }
                    this._log.error("Illegal Stop {}", (Object)s);
                }
            }
        }
        for (Pathway p : newPathways) {
            dao.saveEntity(p);
        }
    }

    private Collection<List<Stop>> getComplexList(GtfsDao dao) {
        Map<String, Stop> stops = this.getStopMap(dao);
        ArrayList<List<Stop>> complexes = new ArrayList<List<Stop>>();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(this.complexFile)));){
            String line;
            while ((line = br.readLine()) != null) {
                ArrayList<Stop> complex = new ArrayList<Stop>();
                for (String id : line.split(STOP_SEPARATOR)) {
                    Stop stop = stops.get(id);
                    if (stop == null) {
                        this._log.info("null stop: {}", (Object)id);
                    }
                    complex.add(stop);
                }
                complexes.add(complex);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return complexes;
    }

    private Map<String, Stop> getStopMap(GtfsDao dao) {
        HashMap<String, Stop> map = new HashMap<String, Stop>();
        for (Stop stop : dao.getAllStops()) {
            if (stop.getLocationType() != 0) continue;
            map.put(stop.getId().getId(), stop);
        }
        return map;
    }

    public void setComplexFile(String complexFile) {
        this.complexFile = complexFile;
    }

    public void setGenericPathwayTraversalTime(int genericPathwayTraversalTime) {
        this.genericPathwayTraversalTime = genericPathwayTraversalTime;
    }

    public void setType(Type type) {
        this.typeInternal = type;
    }

    public void setPathwayType(PathwayType type) {
        this.pathwayType = type;
    }

    private static enum PathwayType {
        MODE_LINK,
        MODE_WALKWAY,
        MODE_STAIRS,
        MODE_MOVING_SIDEWALK,
        MODE_ESCALATOR,
        MODE_ELEVATOR,
        MODE_FAREGATE,
        MODE_EXIT_GATE;

    }

    private static enum Type {
        PATHWAYS,
        PARENT_STATION;

    }
}

