/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Collection;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SanitizeForApiAccess
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(SanitizeForApiAccess.class);
    private String identityBean;
    @CsvField(optional=true)
    private String regex = "[\\[\\]\\@\\.\\ \\:\\\\\\(\\)\\_\\-\\/\\\"]";
    @CsvField(optional=true)
    private Boolean verbose = false;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        String output = "The following " + this.identityBean + " were changed: ";
        if (this.identityBean.equalsIgnoreCase("trip")) {
            this._log.info("Removing characters from " + this.identityBean + " using this regex: " + this.regex);
            Collection<Trip> trips = dao.getAllTrips();
            for (Trip trip : trips) {
                String newId = trip.getId().getId().replaceAll(this.regex, "");
                if (newId.equals(trip.getId().getId())) continue;
                trip.getId().setId(newId);
                output = output + trip.getId().getId() + ", ";
            }
        } else if (this.identityBean.equalsIgnoreCase("stop")) {
            this._log.info("Removing characters from " + this.identityBean + " using this regex: " + this.regex);
            Collection<Stop> stops = dao.getAllStops();
            for (Stop stop : stops) {
                String newId = stop.getId().getId().replaceAll(this.regex, "");
                if (newId.equals(stop.getId().getId())) continue;
                stop.getId().setId(newId);
                output = output + stop.getId().getId() + ", ";
            }
        } else if (this.identityBean.equalsIgnoreCase("route")) {
            this._log.info("Removing characters from " + this.identityBean + " using this regex: " + this.regex);
            Collection<Route> routes = dao.getAllRoutes();
            for (Route route : routes) {
                String newId = route.getId().getId().replaceAll(this.regex, "");
                if (newId.equals(route.getId().getId())) continue;
                route.getId().setId(newId);
                output = output + route.getId().getId() + ", ";
            }
        } else {
            this._log.error("No matching Bean Type " + this.identityBean);
            return;
        }
        if (this.verbose.booleanValue()) {
            this._log.info(output.substring(0, output.length() - 2));
        }
    }

    public void setIdentityBean(String identityBean) {
        this.identityBean = identityBean;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

