/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.HashSet;
import java.util.List;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveUnusedRoutes
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(RemoveUnusedRoutes.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext transformContext, GtfsMutableRelationalDao gtfsMutableRelationalDao) {
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        HashSet<Route> routesToRemove = new HashSet<Route>();
        for (Route route : gtfsMutableRelationalDao.getAllRoutes()) {
            List<Trip> tripsInRoute = gtfsMutableRelationalDao.getTripsForRoute(route);
            if (tripsInRoute.size() >= 1) continue;
            routesToRemove.add(route);
        }
        for (Route route : routesToRemove) {
            removeEntityLibrary.removeRoute(gtfsMutableRelationalDao, route);
        }
    }
}

