/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Calendar;
import java.util.Date;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveCurrentService
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(RemoveCurrentService.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        Date today = this.removeTime(new Date());
        for (AgencyAndId aai : dao.getAllServiceIds()) {
            boolean hasEntryToday = false;
            for (ServiceCalendarDate calDate : dao.getCalendarDatesForServiceId(aai)) {
                Date date = this.removeTime(calDate.getDate().getAsDate());
                if (!date.equals(today)) continue;
                hasEntryToday = true;
                if (calDate.getExceptionType() != 1) continue;
                calDate.setExceptionType(2);
                dao.saveOrUpdateEntity(calDate);
            }
            if (hasEntryToday) continue;
            this._log.info("No entry for today, adding one, id: {}", (Object)aai);
            ServiceCalendarDate calendarDate = new ServiceCalendarDate();
            calendarDate.setServiceId(aai);
            calendarDate.setDate(new ServiceDate(today));
            calendarDate.setExceptionType(2);
            dao.saveOrUpdateEntity(calendarDate);
        }
    }

    private Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }
}

