/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.InputLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeStopNamesFromReferenceStrategy
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(MergeStopNamesFromReferenceStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        Map<String, String> map = new InputLibrary().readOrderedMap((String)context.getParameter("stopMappingFile"));
        Map<String, String> regexMap = new InputLibrary().readOrderedMap((String)context.getParameter("regexFile"));
        for (Stop stop : dao.getAllStops()) {
            String upperCaseName = stop.getName();
            Object beautifiedName = "";
            if (upperCaseName == null) continue;
            for (String s : upperCaseName.split(" ")) {
                beautifiedName = (String)beautifiedName + this.toProperCase(s) + " ";
            }
            beautifiedName = ((String)beautifiedName).substring(0, ((String)beautifiedName).length() - 1);
            for (String regex : regexMap.keySet()) {
                try {
                    beautifiedName = ((String)beautifiedName).replaceAll(regex, regexMap.get(regex));
                }
                catch (PatternSyntaxException pse) {
                    this._log.error(" invalid regex combination |{}|=|{}|", regex, regexMap.get(regex), pse);
                }
            }
            if (map.containsKey(beautifiedName)) {
                this._log.trace("swapped |{}| for |{}|", beautifiedName, (Object)map.get(beautifiedName));
                beautifiedName = map.get(beautifiedName);
            }
            stop.setName((String)beautifiedName);
        }
    }

    private String toProperCase(String s) {
        if (s == null || s.length() < 2) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }
}

