/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.List;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.InputLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeStopIdsFromControlStrategy
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(MergeStopIdsFromControlStrategy.class);
    private static final int LOCATION_NAME_INDEX = 0;
    private static final int ATIS_ID_INDEX = 6;
    @CsvField(ignore=true)
    private String _referenceAgencyId = null;
    @CsvField(ignore=true)
    private String _daoAgencyId = null;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        List<String> controlLines = new InputLibrary().readList((String)context.getParameter("controlFile"));
        int matched = 0;
        int unmatched = 0;
        for (String controlLine : controlLines) {
            String[] controlArray = controlLine.split(",");
            if (controlArray == null || controlArray.length < 2) {
                this._log.info("bad control line {}", (Object)controlLine);
                continue;
            }
            String gtfsId = controlArray[0];
            String atisId = controlArray[6];
            Stop gtfsStop = reference.getStopForId(new AgencyAndId(this.getReferenceAgencyId(reference), gtfsId));
            if (gtfsStop == null) {
                this._log.info("missing reference stop {} for agency {}", (Object)gtfsId, (Object)this.getReferenceAgencyId(reference));
                ++unmatched;
                continue;
            }
            Stop atisStop = dao.getStopForId(new AgencyAndId(this.getDaoAgencyId(dao), atisId));
            if (atisStop == null) {
                this._log.info("missing atis stop {} for agency {}", (Object)atisId, (Object)this.getDaoAgencyId(dao));
                ++unmatched;
                continue;
            }
            ++matched;
            atisStop.setName(gtfsStop.getName());
            atisStop.setDirection(gtfsStop.getDirection());
            atisStop.setId(gtfsStop.getId());
        }
        this._log.info("Complete with {} matched and {} unmatched", (Object)matched, (Object)unmatched);
    }

    private String getReferenceAgencyId(GtfsMutableRelationalDao dao) {
        if (this._referenceAgencyId == null) {
            this._referenceAgencyId = dao.getAllAgencies().iterator().next().getId();
        }
        return this._referenceAgencyId;
    }

    private String getDaoAgencyId(GtfsMutableRelationalDao dao) {
        if (this._daoAgencyId == null) {
            this._daoAgencyId = dao.getAllAgencies().iterator().next().getId();
        }
        return this._daoAgencyId;
    }
}

