/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeRouteFromReferenceStrategyById
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(MergeRouteFromReferenceStrategyById.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        ArrayList<Route> routesToRemove = new ArrayList<Route>();
        HashMap<String, Route> referenceRoutes = new HashMap<String, Route>();
        for (Route route : reference.getAllRoutes()) {
            referenceRoutes.put(route.getId().getId(), route);
        }
        this._log.info("Routes: {}, Trips: {}", (Object)dao.getAllRoutes().size(), (Object)dao.getAllTrips().size());
        for (Route route : dao.getAllRoutes()) {
            String identifier = route.getId().getId();
            Route refRoute = (Route)referenceRoutes.get(identifier);
            if (refRoute != null) {
                this.setRoute(route, refRoute);
                continue;
            }
            if (!identifier.contains("-LTD")) continue;
            refRoute = (Route)referenceRoutes.get(identifier = identifier.replace("-LTD", ""));
            if (refRoute != null) {
                this.updateTripHeadsign(dao, route);
                if (dao.getRouteForId(new AgencyAndId(route.getId().getAgencyId(), refRoute.getId().getId())) != null) {
                    routesToRemove.add(route);
                    for (Trip trip : dao.getTripsForRoute(route)) {
                        trip.setRoute(dao.getRouteForId(new AgencyAndId(route.getId().getAgencyId(), refRoute.getId().getId())));
                    }
                    continue;
                }
                this.setLTDRoute(route, refRoute);
                continue;
            }
            if (identifier.equals("Q6")) {
                refRoute = (Route)referenceRoutes.get("Q06");
                if (refRoute == null) continue;
                this.updateTripHeadsign(dao, route);
                if (dao.getRouteForId(new AgencyAndId(route.getId().getAgencyId(), "Q6")) == null) continue;
                routesToRemove.add(route);
                for (Trip trip : dao.getTripsForRoute(route)) {
                    trip.setRoute(dao.getRouteForId(new AgencyAndId(route.getId().getAgencyId(), "Q6")));
                }
                continue;
            }
            this._log.info("No reference route for route: " + route.getId().getId());
        }
        this._log.info("Routes to remove: " + routesToRemove.size());
        for (Route route : routesToRemove) {
            dao.removeEntity(route);
        }
        this._log.info("Routes: {}, Trips: {}", (Object)dao.getAllRoutes().size(), (Object)dao.getAllTrips().size());
    }

    private void updateTripHeadsign(GtfsMutableRelationalDao dao, Route route) {
        for (Trip trip : dao.getTripsForRoute(route)) {
            String tripHeadSign = trip.getTripHeadsign();
            if (tripHeadSign == null) continue;
            tripHeadSign = tripHeadSign.concat(" LTD");
            trip.setTripHeadsign(tripHeadSign);
        }
    }

    private void setRoute(Route daoRoute, Route refRoute) {
        daoRoute.setShortName(refRoute.getShortName());
        daoRoute.setLongName(refRoute.getLongName());
        daoRoute.setType(refRoute.getType());
        daoRoute.setDesc(refRoute.getDesc());
        daoRoute.setUrl(refRoute.getUrl());
        daoRoute.setColor(refRoute.getColor());
        daoRoute.setTextColor(refRoute.getTextColor());
    }

    private void setLTDRoute(Route daoRoute, Route refRoute) {
        daoRoute.setShortName(refRoute.getShortName());
        daoRoute.setLongName(refRoute.getLongName());
        daoRoute.setType(refRoute.getType());
        daoRoute.setDesc(refRoute.getDesc());
        daoRoute.setUrl(refRoute.getUrl());
        daoRoute.setColor(refRoute.getColor());
        daoRoute.setTextColor(refRoute.getTextColor());
        daoRoute.setId(refRoute.getId());
    }
}

