/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeRouteFive
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(MergeRouteFive.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        String agency = dao.getAllTrips().iterator().next().getId().getAgencyId();
        Route routeFive = dao.getRouteForId(new AgencyAndId(agency, "5"));
        Route routeFiveX = dao.getRouteForId(new AgencyAndId(agency, "5X"));
        if (routeFive != null && routeFiveX != null) {
            for (Trip trip : dao.getTripsForRoute(routeFiveX)) {
                trip.setRoute(routeFive);
            }
            dao.removeEntity(routeFiveX);
        }
    }
}

