/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.HashMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTASubwayShuttleRouteStrategy
implements GtfsTransformStrategy {
    private static final Logger _log = LoggerFactory.getLogger(MTASubwayShuttleRouteStrategy.class);
    private static final String SHUTTLE_HEADSIGN_SUFFIX = "SHUTTLE BUS";
    private static final String SHUTTLE_ID_SUFFIX = "-SS";
    private static final String SHUTTLE_NAME_SUFFIX = " Shuttle";
    private static final int SHUTTLE_ROUTE_TYPE = 714;
    private static final String SHUTTLE_STOP_SUFFIX = "SHUTTLE BUS STOP";

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        HashMap<Route, Route> shuttleRoutes = new HashMap<Route, Route>();
        for (Trip trip : dao.getAllTrips()) {
            if (!trip.getTripHeadsign().endsWith(SHUTTLE_HEADSIGN_SUFFIX)) continue;
            Route shuttleRoute = shuttleRoutes.computeIfAbsent(trip.getRoute(), r -> this.getShuttleRoute(dao, (Route)r));
            trip.setRoute(shuttleRoute);
            dao.updateEntity(trip);
        }
        HashMap<String, String> parentStopByMtaStopId = new HashMap<String, String>();
        for (Stop stop : dao.getAllStops()) {
            if (stop.getName().endsWith(SHUTTLE_STOP_SUFFIX) || stop.getParentStation() == null) continue;
            parentStopByMtaStopId.put(stop.getMtaStopId(), stop.getParentStation());
        }
        for (Stop stop : dao.getAllStops()) {
            if (!stop.getName().endsWith(SHUTTLE_STOP_SUFFIX)) continue;
            String parent = (String)parentStopByMtaStopId.get(stop.getMtaStopId());
            if (parent == null) {
                _log.info("No parent for shuttle stop {}", (Object)stop.getId());
            }
            stop.setParentStation(parent);
            dao.updateEntity(stop);
        }
    }

    private Route getShuttleRoute(GtfsMutableRelationalDao dao, Route orig) {
        Route shuttleRoute = new Route(orig);
        AgencyAndId id = new AgencyAndId(shuttleRoute.getId().getAgencyId(), shuttleRoute.getId().getId() + SHUTTLE_ID_SUFFIX);
        shuttleRoute.setId(id);
        shuttleRoute.setShortName(shuttleRoute.getShortName() + SHUTTLE_ID_SUFFIX);
        shuttleRoute.setLongName(shuttleRoute.getLongName() + SHUTTLE_NAME_SUFFIX);
        shuttleRoute.setType(714);
        dao.saveEntity(shuttleRoute);
        return shuttleRoute;
    }
}

