/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputLibrary {
    private final Logger _log = LoggerFactory.getLogger(InputLibrary.class);

    public List<String> readList(String fileName) {
        ArrayList<String> list = new ArrayList<String>();
        if (fileName == null || fileName.length() == 0) {
            return list;
        }
        BufferedReader reader = null;
        int count = 0;
        try {
            reader = new BufferedReader(new FileReader(fileName));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String s = this.sanitize(line);
                if (s == null) continue;
                list.add(s);
                ++count;
            }
        }
        catch (FileNotFoundException e) {
            this._log.error("failed to load stop ignore file={}", (Object)fileName, (Object)e);
            return list;
        }
        catch (IOException ioe) {
            this._log.error("error reading stop ignore file={}", (Object)fileName, (Object)ioe);
        }
        this._log.info("Successfully read {} entries from {}", (Object)count, (Object)fileName);
        return list;
    }

    public Map<String, String> readOrderedMap(String fileName) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (fileName == null || fileName.length() == 0) {
            return map;
        }
        BufferedReader reader = null;
        int count = 0;
        try {
            reader = new BufferedReader(new FileReader(fileName));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] strings = line.split("\t");
                if (strings == null || strings.length <= 1) continue;
                ++count;
                String key = strings[0];
                String value = strings[1];
                map.put(this.sanitize(key), this.sanitize(value));
            }
        }
        catch (FileNotFoundException e) {
            this._log.error("failed to load stop mapping file={}", (Object)fileName, (Object)e);
            return map;
        }
        catch (IOException ioe) {
            this._log.error("error reading mapping file {} = {}", fileName, ioe, ioe);
        }
        this._log.info("Successfully read {} entries from {}", (Object)count, (Object)fileName);
        return map;
    }

    private String sanitize(String s) {
        if (s == null) {
            return s;
        }
        s = s.trim();
        s = s.replaceAll("^\"", "").replaceAll("\"$", "");
        return s;
    }
}

