/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.util.PathwayUtil;

public class InferPathwaysFromEntrancesStrategy
implements GtfsTransformStrategy {
    private static final int WHEELCHAIR_BOARDING_ALLOWED = 1;
    private static final int STOP_TYPE = 0;
    private static final int STATION_TYPE = 1;
    private static final int ENTRANCE_TYPE = 2;
    @CsvField(optional=true)
    private int traversalTime = 60;
    @CsvField(optional=true)
    private int wheelchairTraversalTime = 120;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        String agencyId = dao.getAllStops().iterator().next().getId().getId();
        ArrayList<Pathway> pathways = new ArrayList<Pathway>();
        PathwayUtil pathwayUtil = new PathwayUtil(agencyId, pathways);
        HashMap<String, ArrayList<Stop>> stopMap = new HashMap<String, ArrayList<Stop>>();
        for (Stop stop : dao.getAllStops()) {
            ArrayList<Stop> stops;
            String station = stop.getParentStation();
            if (stop.getLocationType() == 1) {
                station = stop.getId().getId();
            }
            if ((stops = (ArrayList<Stop>)stopMap.get(station)) == null) {
                stops = new ArrayList<Stop>();
                stopMap.put(station, stops);
            }
            stops.add(stop);
        }
        for (List stationStops : stopMap.values()) {
            ArrayList<Stop> stops = new ArrayList<Stop>();
            ArrayList<Stop> entrances = new ArrayList<Stop>();
            Stop station = null;
            for (Stop stop : stationStops) {
                if (stop.getLocationType() == 0) {
                    stops.add(stop);
                    continue;
                }
                if (stop.getLocationType() == 2) {
                    entrances.add(stop);
                    continue;
                }
                if (stop.getLocationType() != 1) continue;
                station = stop;
            }
            if (station == null || stops.isEmpty() || entrances.isEmpty()) continue;
            for (Stop stop : stops) {
                for (Stop entrance : entrances) {
                    String id = stop.getId().getId();
                    int accessibleTime = -1;
                    if (stop.getWheelchairBoarding() == 1) {
                        accessibleTime = this.wheelchairTraversalTime;
                    } else if (stop.getWheelchairBoarding() == 0 && station.getWheelchairBoarding() == 1) {
                        accessibleTime = this.wheelchairTraversalTime;
                    }
                    pathwayUtil.createPathway(stop, entrance, 1, this.traversalTime, id, null);
                }
            }
        }
        for (Pathway pathway : pathways) {
            dao.saveEntity(pathway);
        }
    }

    public void setTraversalTime(int traversalTime) {
        this.traversalTime = traversalTime;
    }

    public void setWheelchairTraversalTime(int wheelchairTraversalTime) {
        this.wheelchairTraversalTime = wheelchairTraversalTime;
    }
}

