/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.CheckForLengthyRouteNames;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnsureRouteLongNameExists
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(CheckForLengthyRouteNames.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        HashMap routeToHeadsignToCount = new HashMap();
        Collection<Trip> trips = dao.getAllTrips();
        for (Trip trip : trips) {
            AgencyAndId routeId = trip.getRoute().getId();
            String headsign = trip.getTripHeadsign();
            HashMap<String, Integer> headsignCounts = (HashMap<String, Integer>)routeToHeadsignToCount.get(trip.getRoute().getId());
            if (headsignCounts == null) {
                headsignCounts = new HashMap<String, Integer>();
                routeToHeadsignToCount.put(routeId, headsignCounts);
            }
            if (headsignCounts.get(headsign) == null) {
                headsignCounts.put(headsign, 0);
            }
            headsignCounts.put(headsign, (Integer)headsignCounts.get(headsign) + 1);
        }
        for (Map.Entry entry : routeToHeadsignToCount.entrySet()) {
            String h1 = "";
            String h2 = "";
            int n1 = 0;
            int n2 = 0;
            for (Map.Entry headsignCount : ((HashMap)entry.getValue()).entrySet()) {
                int n = (Integer)headsignCount.getValue();
                String h = (String)headsignCount.getKey();
                if (n <= n2) continue;
                if (n > n1) {
                    n2 = n1;
                    n1 = n;
                    h2 = h1;
                    h1 = h;
                    continue;
                }
                n2 = n;
                h2 = h;
            }
            Route route = dao.getRouteForId((AgencyAndId)entry.getKey());
            if (route.getLongName() == null) continue;
            route.setLongName(h1 + " - " + h2);
            dao.updateEntity(route);
        }
    }
}

