/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountAndTestSubway
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(CountAndTestSubway.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        void var9_18;
        void var10_22;
        void var9_16;
        void var9_14;
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        String agency = dao.getAllAgencies().iterator().next().getId();
        String name = dao.getAllAgencies().iterator().next().getName();
        HashMap<String, Route> referenceRoutes = new HashMap<String, Route>();
        for (Route route : reference.getAllRoutes()) {
            referenceRoutes.put(route.getId().getId(), route);
        }
        HashMap<String, Trip> referenceTrips = new HashMap<String, Trip>();
        for (Trip trip : reference.getAllTrips()) {
            referenceTrips.put(trip.getId().getId(), trip);
        }
        HashMap<String, Stop> hashMap = new HashMap<String, Stop>();
        for (Stop stop : reference.getAllStops()) {
            hashMap.put(stop.getId().getId(), stop);
        }
        boolean bl = false;
        for (Route route : dao.getAllRoutes()) {
            if (referenceRoutes.containsKey(route.getId().getId())) {
                ++var9_14;
                continue;
            }
            this._log.info("ATIS route {} doesn't have match in reference", (Object)route.getId().getId());
        }
        this._log.info("ATIS Routes: {}, References: {}, ATIS match to reference: {}", dao.getAllRoutes().size(), reference.getAllRoutes().size(), (int)var9_14);
        boolean bl2 = false;
        int countCd = 0;
        int countNoSt = 0;
        int countNoCd = 0;
        int countNoHs = 0;
        int curSerTrips = 0;
        AgencyAndId serviceAgencyAndId = new AgencyAndId();
        boolean bl3 = false;
        block4: for (Trip trip : dao.getAllTrips()) {
            if (referenceTrips.containsKey(trip.getId().getId())) {
                ++var9_16;
            }
            if (dao.getStopTimesForTrip(trip).size() == 0) {
                ++countNoSt;
            } else {
                ++var10_22;
            }
            serviceAgencyAndId = trip.getServiceId();
            if (dao.getCalendarDatesForServiceId(serviceAgencyAndId).size() == 0) {
                ++countNoCd;
            } else {
                ++countCd;
            }
            if (trip.getTripHeadsign() == null) {
                ++countNoHs;
            }
            for (ServiceCalendarDate calDate : dao.getCalendarDatesForServiceId(trip.getServiceId())) {
                Date date = this.constructDate(calDate.getDate());
                Date today = this.removeTime(new Date());
                if (calDate.getExceptionType() != 1 || !date.equals(today)) continue;
                ++curSerTrips;
                continue block4;
            }
        }
        this._log.info("ATIS Trips: {}, Reference: {}, match: {}, Current Service: {}", dao.getAllTrips().size(), reference.getAllTrips().size(), (int)var9_16, curSerTrips);
        this._log.info("Total stop times {}, Trips w/ st: {}, Trips w/out st: {}", dao.getAllStopTimes().size(), (int)var10_22, countNoSt);
        this._log.info("Total calendar dates {}, Trips w/cd {}, Trips w/out cd: {}", dao.getAllCalendarDates().size(), countCd, countNoCd);
        this._log.info("Total trips w/out headsign: {}", (Object)countNoHs);
        boolean bl4 = false;
        for (Stop stop : dao.getAllStops()) {
            if (!hashMap.containsKey(stop.getId().getId())) continue;
            ++var9_18;
        }
        this._log.info("ATIS Stops: {}, Reference: {}, ATIS match to reference: {}", dao.getAllStops().size(), reference.getAllStops().size(), (int)var9_18);
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        String feed = CloudContextService.getLikelyFeedName(dao);
        es.publishMetric(CloudContextService.getNamespace(), "SubwayTripsInServiceToday", "feed", feed, curSerTrips);
        if (countNoHs > 0) {
            this._log.error("There are trips with no headsign");
        }
        es.publishMetric(CloudContextService.getNamespace(), "TripsWithoutHeadsigns", "feed", feed, countNoHs);
        HashSet<String> ids = new HashSet<String>();
        for (Stop stop : dao.getAllStops()) {
            if (ids.contains(stop.getId().getId())) {
                this._log.error("Duplicate stop ids! Agency {} stop id {}", (Object)agency, (Object)stop.getId().getId());
                es.publishMultiDimensionalMetric(CloudContextService.getNamespace(), "DuplicateStopIds", new String[]{"feed", "stopId"}, new String[]{feed, stop.getId().toString()}, 1.0);
                throw new IllegalStateException("There are duplicate stop ids!");
            }
            ids.add(stop.getId().getId());
        }
    }

    private Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    private Date constructDate(ServiceDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, date.getYear());
        calendar.set(2, date.getMonth() - 1);
        calendar.set(5, date.getDay());
        Date date1 = calendar.getTime();
        date1 = this.removeTime(date1);
        return date1;
    }
}

