/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountAndTestBus
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(CountAndTestBus.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        void var10_19;
        void var11_23;
        void var10_17;
        void var10_15;
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        CalendarService refCalendarService = CalendarServiceDataFactoryImpl.createService(reference);
        String agency = dao.getAllTrips().iterator().next().getId().getAgencyId();
        String name = dao.getAllAgencies().iterator().next().getName();
        HashMap<String, Route> referenceRoutes = new HashMap<String, Route>();
        for (Route route : reference.getAllRoutes()) {
            referenceRoutes.put(route.getId().getId(), route);
        }
        HashMap<String, Trip> referenceTrips = new HashMap<String, Trip>();
        for (Trip trip : reference.getAllTrips()) {
            referenceTrips.put(trip.getId().getId(), trip);
        }
        HashMap<String, Stop> hashMap = new HashMap<String, Stop>();
        for (Stop stop : reference.getAllStops()) {
            hashMap.put(stop.getId().getId(), stop);
        }
        boolean bl = false;
        for (Route route : dao.getAllRoutes()) {
            if (referenceRoutes.containsKey(route.getId().getId())) {
                ++var10_15;
                continue;
            }
            this._log.info("ATIS route {} doesn't have match in reference", (Object)route.getId().getId());
        }
        this._log.info("ATIS Routes: {}, References: {}, ATIS match to reference: {}", dao.getAllRoutes().size(), reference.getAllRoutes().size(), (int)var10_15);
        boolean bl2 = false;
        int countCd = 0;
        int countNoSt = 0;
        int countNoCd = 0;
        int curSerTrips = 0;
        int countNoHs = 0;
        int atisTripsThisWeek = 0;
        int refTripsThisWeek = 0;
        int matchingTripsThisWeek = 0;
        AgencyAndId serviceAgencyAndId = new AgencyAndId();
        boolean bl3 = false;
        ArrayList<String> matchingIds = new ArrayList<String>();
        ArrayList<String> matchingIdsThisWeek = new ArrayList<String>();
        for (Trip trip : dao.getAllTrips()) {
            if (trip.getId().getId() != null) {
                if (referenceTrips.containsKey(trip.getId().getId())) {
                    ++var10_17;
                    matchingIds.add(trip.getId().getId());
                }
                if (this.tripIsThisWeek(dao.getCalendarDatesForServiceId(trip.getServiceId()))) {
                    ++atisTripsThisWeek;
                    if (referenceTrips.containsKey(trip.getId().getId())) {
                        matchingIdsThisWeek.add(trip.getId().getId());
                    }
                }
            }
            if (dao.getStopTimesForTrip(trip).size() == 0) {
                ++countNoSt;
            } else {
                ++var11_23;
            }
            serviceAgencyAndId = trip.getServiceId();
            if (dao.getCalendarDatesForServiceId(serviceAgencyAndId).size() == 0) {
                ++countNoCd;
            } else {
                ++countCd;
            }
            for (ServiceCalendarDate calDate : dao.getCalendarDatesForServiceId(trip.getServiceId())) {
                Date date = this.constructDate(calDate.getDate());
                Date today = this.removeTime(new Date());
                if (calDate.getExceptionType() != 1 || !date.equals(today)) continue;
                ++curSerTrips;
                break;
            }
            if (trip.getTripHeadsign() == null) {
                ++countNoHs;
            }
            if (trip.getId().getId() == null || !referenceTrips.containsKey(trip.getId().getId())) continue;
            ++var10_17;
            matchingIds.add(trip.getId().getId());
        }
        int noMatch = 0;
        int noMatchNoSdon = 0;
        int noMatchNoSdonNoH9 = 0;
        int refTripsWithSdon = 0;
        int refTripsWoutSdonWithh9 = 0;
        int refTripsThisWeekWithSdon = 0;
        int refTripsThisWeekWoutSdonWithA9 = 0;
        int refTripsThisWeekWoutSdonWithE9 = 0;
        int refTripsThisWeekWoutSdonWithD9 = 0;
        int refTripsThisWeekWoutSdonWithB9 = 0;
        int refTripsThisWeekWoutSdonWithH9 = 0;
        boolean checkMatchesThisWeek = false;
        int doesntMatchThisWeek = 0;
        int leftOverNoMatchThisWeek = 0;
        ArrayList<String> refTripsMissingATIS = new ArrayList<String>();
        for (Trip refTrip : reference.getAllTrips()) {
            Set<ServiceDate> activeDates = refCalendarService.getServiceDatesForServiceId(refTrip.getServiceId());
            if (this.tripIsThisWeek(activeDates)) {
                ++refTripsThisWeek;
                if (!matchingIdsThisWeek.contains(refTrip.getId().getId())) {
                    ++doesntMatchThisWeek;
                    if (refTrip.getId().getId().contains("SDon")) {
                        ++refTripsThisWeekWithSdon;
                    } else if (refTrip.getId().getId().contains("A9")) {
                        ++refTripsThisWeekWoutSdonWithA9;
                    } else if (refTrip.getId().getId().contains("B9")) {
                        ++refTripsThisWeekWoutSdonWithB9;
                    } else if (refTrip.getId().getId().contains("D9")) {
                        ++refTripsThisWeekWoutSdonWithD9;
                    } else if (refTrip.getId().getId().contains("E9")) {
                        ++refTripsThisWeekWoutSdonWithE9;
                    } else if (refTrip.getId().getId().contains("H9")) {
                        ++refTripsThisWeekWoutSdonWithH9;
                    } else {
                        ++leftOverNoMatchThisWeek;
                    }
                } else {
                    ++matchingTripsThisWeek;
                }
            }
            if (matchingIds.contains(refTrip.getId().getId())) continue;
            refTripsMissingATIS.add(refTrip.getId().getId());
            ++noMatch;
            if (!refTrip.getId().getId().contains("SDon")) {
                ++noMatchNoSdon;
                if (!refTrip.getId().getId().contains("H9")) {
                    ++noMatchNoSdonNoH9;
                    continue;
                }
                ++refTripsWoutSdonWithh9;
                continue;
            }
            ++refTripsWithSdon;
        }
        this._log.info("ATIS Trips: {}, Reference: {}, match: {}, In ref NotInATIS: {}, In ref NotInATIS Sdon: {}, In ref NotInATIS not Sdon is H9: {}, Current Service: {}", dao.getAllTrips().size(), reference.getAllTrips().size(), (int)var10_17, noMatch, refTripsWithSdon, refTripsWoutSdonWithh9, curSerTrips);
        this._log.info("ATIS Trips this week {}, Reference trips this week {}, ATIS Trips this week that are also Reference Trips this week {}", atisTripsThisWeek, refTripsThisWeek, matchingTripsThisWeek);
        this._log.info("Matches this week {}", (Object)matchingTripsThisWeek);
        this._log.info("This week matches: {}. This week doesn't match {}, in ref NotInATIS Sdon: {}, In ref NotInATIS not Sdon is A9: {}, B9: {} E9: {}, H9: {}, Leftover: {}", matchingTripsThisWeek, doesntMatchThisWeek, refTripsThisWeekWithSdon, refTripsThisWeekWoutSdonWithA9, refTripsThisWeekWoutSdonWithB9, refTripsThisWeekWoutSdonWithE9, refTripsThisWeekWoutSdonWithH9, leftOverNoMatchThisWeek);
        this._log.info("Stops: {}, Stop times {}, Trips w/ st: {}, Trips w/out st: {}", dao.getAllStops().size(), dao.getAllStopTimes().size(), (int)var11_23, countNoSt);
        this._log.info("Calendar dates: {}, Trips w/cd {}, Trips w/out cd: {}", dao.getAllCalendarDates().size(), countCd, countNoCd);
        this._log.info("Total trips w/out headsign: {}", (Object)countNoHs);
        boolean bl4 = false;
        for (Stop stop : dao.getAllStops()) {
            if (!hashMap.containsKey(stop.getId().getId())) continue;
            ++var10_19;
        }
        this._log.info("ATIS Stops: {}, Reference: {}, ATIS match to reference: {}", dao.getAllStops().size(), reference.getAllStops().size(), (int)var10_19);
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        String feed = CloudContextService.getLikelyFeedName(dao);
        es.publishMetric(CloudContextService.getNamespace(), "ATISBusTripsThisWeek", "feed", feed, atisTripsThisWeek);
        es.publishMetric(CloudContextService.getNamespace(), "refBusTripsThisWeek", "feed", feed, refTripsThisWeek);
        es.publishMetric(CloudContextService.getNamespace(), "matchingBusTripsThisWeek", "feed", feed, matchingTripsThisWeek);
        es.publishMetric(CloudContextService.getNamespace(), "SdonBusTripsThisWeek", "feed", feed, refTripsThisWeekWithSdon);
        es.publishMetric(CloudContextService.getNamespace(), "A9BusTripsThisWeek", "feed", feed, refTripsThisWeekWoutSdonWithA9);
        es.publishMetric(CloudContextService.getNamespace(), "B9BusTripsThisWeek", "feed", feed, refTripsThisWeekWoutSdonWithB9);
        es.publishMetric(CloudContextService.getNamespace(), "D9BusTripsThisWeek", "feed", feed, refTripsThisWeekWoutSdonWithD9);
        es.publishMetric(CloudContextService.getNamespace(), "E9BusTripsThisWeek", "feed", feed, refTripsThisWeekWoutSdonWithE9);
        es.publishMetric(CloudContextService.getNamespace(), "H9BusTripsWitThisWeek", "feed", feed, refTripsThisWeekWoutSdonWithH9);
        es.publishMetric(CloudContextService.getNamespace(), "OtherTripsWithoutMatchThisWeek", "feed", feed, leftOverNoMatchThisWeek);
        if (curSerTrips < 1) {
            throw new IllegalStateException("There is no current service!!");
        }
        es.publishMetric(CloudContextService.getNamespace(), "BusTripsInServiceToday", "feed", feed, curSerTrips);
        if (countNoHs > 0) {
            this._log.error("There are trips with no headsign");
        }
        es.publishMetric(CloudContextService.getNamespace(), "TripsWithoutHeadsigns", "feed", feed, countNoHs);
        HashSet<String> ids = new HashSet<String>();
        for (Stop stop : dao.getAllStops()) {
            if (ids.contains(stop.getId().getId())) {
                if (!ids.contains(stop.getId().getId())) continue;
                this._log.error("Duplicate stop ids! Agency {} stop id {}", (Object)agency, (Object)stop.getId().getId());
                es.publishMultiDimensionalMetric(CloudContextService.getLikelyFeedName(dao), "DuplicateStopIds", new String[]{"feed", "stopId"}, new String[]{feed, stop.getId().toString()}, 1.0);
                continue;
            }
            ids.add(stop.getId().getId());
        }
    }

    private boolean tripIsThisWeek(Set<ServiceDate> serviceDates) {
        Date today = this.removeTime(new Date());
        Date inOneWeek = this.removeTime(this.addDays(new Date(), 7));
        for (ServiceDate calDate : serviceDates) {
            Date date = this.removeTime(calDate.getAsDate());
            if (!date.after(today) || !date.before(inOneWeek)) continue;
            return true;
        }
        return false;
    }

    private boolean tripIsThisWeek(List<ServiceCalendarDate> serviceDates) {
        Date today = this.removeTime(new Date());
        Date inOneWeek = this.removeTime(this.addDays(new Date(), 7));
        for (ServiceCalendarDate calDate : serviceDates) {
            Date date = this.constructDate(calDate.getDate());
            if (calDate.getExceptionType() != 1 || !date.after(today) || !date.before(inOneWeek)) continue;
            return true;
        }
        return false;
    }

    private Date addDays(Date date, int daysToAdd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, daysToAdd);
        return cal.getTime();
    }

    private Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    private Date constructDate(ServiceDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, date.getYear());
        calendar.set(2, date.getMonth() - 1);
        calendar.set(5, date.getDay());
        Date date1 = calendar.getTime();
        date1 = this.removeTime(date1);
        return date1;
    }
}

