/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.util.CalendarFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareToReferenceService
implements GtfsTransformStrategy {
    private static final int MAX_MESSAGE_SIZE = 256000;
    private static final Logger _log = LoggerFactory.getLogger(CompareToReferenceService.class);
    @CsvField(ignore=true)
    private String defaultAgencyId = "1";
    private String s3BasePath = null;
    @CsvField(ignore=true)
    private CalendarFunctions helper = new CalendarFunctions();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void setS3BasePath(String path) {
        this.s3BasePath = path;
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao gtfsDao) {
        try {
            this.defaultAgencyId = CloudContextService.getLikelyFeedName(gtfsDao);
            String summaryTopic = CloudContextService.getTopic() + "-atis-summary";
            String detailTopic = CloudContextService.getTopic() + "-atis-detail";
            ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
            String summaryHeader = "depot,unmatched_gtfs_trips,unmatched_reference_trips\n";
            String detailHeader = "depot,unmatched_gtfs_trip_ds,unmatched_reference_trip_ids\n";
            StringBuffer summaryReport = new StringBuffer();
            StringBuffer detailReport = new StringBuffer();
            GtfsMutableRelationalDao referenceDao = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
            Map<String, List<AgencyAndId>> activeTripsByDepot = this.getTripsByDepot(context, gtfsDao);
            Map<String, List<AgencyAndId>> referenceTripsByDepot = this.getTripsByDepot(context, referenceDao);
            String summaryFilename = System.getProperty("java.io.tmpdir") + File.separator + "summary.csv";
            FileWriter summaryFile = new FileWriter(summaryFilename);
            summaryFile.write(summaryHeader);
            String detailFilename = System.getProperty("java.io.tmpdir") + File.separator + "detail.csv";
            FileWriter detailFile = new FileWriter(detailFilename);
            detailFile.write(detailHeader);
            HashSet<String> allDepots = new HashSet<String>();
            allDepots.addAll(activeTripsByDepot.keySet());
            allDepots.addAll(referenceTripsByDepot.keySet());
            for (String depot : allDepots) {
                HashSet gtfsTripIds = new HashSet();
                HashSet referenceTripIds = new HashSet();
                if (activeTripsByDepot.containsKey(depot)) {
                    gtfsTripIds.addAll(activeTripsByDepot.get(depot));
                }
                if (referenceTripsByDepot.containsKey(depot)) {
                    referenceTripIds.addAll(referenceTripsByDepot.get(depot));
                }
                HashSet unmatchedReferenceTrips = new HashSet(referenceTripIds);
                HashSet unmatchedGtfsTrips = new HashSet(gtfsTripIds);
                unmatchedGtfsTrips.removeAll(referenceTripIds);
                unmatchedReferenceTrips.removeAll(gtfsTripIds);
                summaryReport.append(depot).append(",").append(unmatchedGtfsTrips.size()).append(",").append(unmatchedReferenceTrips.size()).append("\n");
                detailReport.append(depot).append(",\"").append(unmatchedGtfsTrips).append("\",\"").append(unmatchedReferenceTrips).append("\"\n");
                detailFile.write(detailReport.toString());
                detailReport = new StringBuffer();
            }
            summaryFile.write(summaryReport.toString());
            summaryFile.close();
            detailFile.close();
            Calendar cal = Calendar.getInstance();
            String year = "" + cal.get(1);
            String month = this.lpad(cal.get(2) + 1, 2);
            String day = this.lpad(cal.get(5), 2);
            String time = this.lpad(cal.get(11), 2) + ":" + this.lpad(cal.get(12), 2);
            String baseurl = this.s3BasePath + "/" + year + "/" + month + "/" + day + "/" + time + "-";
            es.putFile(baseurl + "summary.csv", summaryFilename);
            es.putFile(baseurl + "detail.csv", detailFilename);
            _log.error("{} Unmatched Summary", (Object)this.getName());
            _log.error(summaryReport.toString());
        }
        catch (Throwable t) {
            _log.error("{} failed: {}", this.getName(), t, t);
        }
    }

    private String lpad(int numberToFormat, int totalDigits) {
        Object text = String.valueOf(numberToFormat);
        while (((String)text).length() < totalDigits) {
            text = "0" + (String)text;
        }
        return text;
    }

    private String truncate(String message) {
        if (message.length() > 256000) {
            return message.substring(0, 256000);
        }
        return message;
    }

    private String getDepot(String tripId) {
        String depot = null;
        if (tripId.indexOf("-") < 0) {
            depot = "MISSING";
        } else {
            depot = tripId.split("-")[1];
            if ("Weekday".equals(depot) || "Saturday".equals(depot) || "Sunday".equals(depot)) {
                depot = tripId.split("-")[0];
            }
        }
        if (depot.length() <= 1) {
            depot = "MISSING";
        }
        return depot;
    }

    private Map<String, List<AgencyAndId>> getTripsByDepot(TransformContext context, GtfsMutableRelationalDao dao) {
        HashMap<String, List<AgencyAndId>> tripsByDepot = new HashMap<String, List<AgencyAndId>>();
        for (Trip trip : dao.getAllTrips()) {
            String depot;
            boolean isActive;
            if (trip.getServiceId() == null || !(isActive = this.helper.isTripActive(dao, new ServiceDate(), trip, true))) continue;
            AgencyAndId tripId = trip.getId();
            if (trip.getMtaTripId() != null) {
                tripId = new AgencyAndId(trip.getId().getAgencyId(), trip.getMtaTripId());
            }
            if (!tripsByDepot.containsKey(depot = this.getDepot(tripId.getId()))) {
                tripsByDepot.put(depot, new ArrayList());
            }
            ((List)tripsByDepot.get(depot)).add(this.sanitize(tripId));
        }
        return tripsByDepot;
    }

    private AgencyAndId sanitize(AgencyAndId tripId) {
        if (tripId.getId().contains("-SDon")) {
            return new AgencyAndId(this.defaultAgencyId, tripId.getId().replaceAll("-SDon", ""));
        }
        return new AgencyAndId(this.defaultAgencyId, tripId.getId());
    }
}

