/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Collection;
import java.util.Stack;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckForLengthyRouteNames
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(CheckForLengthyRouteNames.class);
    @CsvField(optional=true)
    int nLongestNames = 20;
    @CsvField(optional=true)
    int logIfLongerThan = 30;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        Collection<Route> routes = dao.getAllRoutes();
        Stack<String> longestRouteNames = new Stack<String>();
        Object longestNames = "";
        Object tooLongNames = "";
        Object namesWithDuplicateParts = "";
        for (Route route : routes) {
            String name = route.getLongName();
            if (name.length() > this.logIfLongerThan) {
                tooLongNames = (String)tooLongNames + name + "\n";
            }
            String[] nameParts = name.split(" ");
            for (int i = 0; i < nameParts.length - 1; ++i) {
                if (!nameParts[i].equals(nameParts[i + 1])) continue;
                namesWithDuplicateParts = (String)namesWithDuplicateParts + name + "\n";
            }
            if (longestRouteNames.size() < this.nLongestNames) {
                longestRouteNames.push(name);
            } else if (((String)longestRouteNames.lastElement()).length() < name.length()) {
                longestRouteNames.pop();
                longestRouteNames.push(name);
            }
            longestRouteNames.sort((a, b) -> a.length() < b.length() ? 1 : -1);
        }
        for (String name : longestRouteNames) {
            longestNames = (String)longestNames + name + "\n";
        }
        this._log.info("Route names with duplicate words: \n" + (String)namesWithDuplicateParts);
        this._log.info("Route names that are too long: \n" + (String)tooLongNames);
        this._log.info("Longest Route names: \n" + (String)longestNames);
    }

    public void setLogIfLongerThan(int logIfLongerThan) {
        this.logIfLongerThan = logIfLongerThan;
    }

    public void setnLongestNames(int nLongestNames) {
        this.nLongestNames = nLongestNames;
    }
}

