/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Date;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.util.CalendarFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckForFutureService
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(CheckForFutureService.class);
    @CsvField(ignore=true)
    private CalendarFunctions helper = new CalendarFunctions();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        int tripsToday = 0;
        int tripsTomorrow = 0;
        int tripsNextDay = 0;
        int tripsDayAfterNext = 0;
        Date today = this.helper.removeTime(new Date());
        Date tomorrow = this.helper.removeTime(this.helper.addDays(new Date(), 1));
        Date nextDay = this.helper.removeTime(this.helper.addDays(new Date(), 2));
        Date dayAfterNext = this.helper.removeTime(this.helper.addDays(new Date(), 3));
        String feed = CloudContextService.getLikelyFeedName(dao);
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        String agency = dao.getAllAgencies().iterator().next().getId();
        String agencyName = dao.getAllAgencies().iterator().next().getName();
        tripsToday = this.hasServiceForDate(dao, today);
        tripsTomorrow = this.hasServiceForDate(dao, tomorrow);
        tripsNextDay = this.hasServiceForDate(dao, nextDay);
        tripsDayAfterNext = this.hasServiceForDate(dao, dayAfterNext);
        this._log.info("Feed for metrics: {}, agency id: {}", (Object)feed, (Object)agencyName);
        es.publishMetric(CloudContextService.getNamespace(), "TripsToday", "feed", feed, tripsToday);
        es.publishMetric(CloudContextService.getNamespace(), "TripsTomorrow", "feed", feed, tripsTomorrow);
        es.publishMetric(CloudContextService.getNamespace(), "TripsIn2Days", "feed", feed, tripsNextDay);
        es.publishMetric(CloudContextService.getNamespace(), "TripsIn3Days", "feed", feed, tripsDayAfterNext);
        this._log.info("TripsToday: {}, feed: {}, namespace: {}", tripsToday, feed, CloudContextService.getNamespace());
        this._log.info("TripsTomorrow: {}, feed: {}, namespace: {}", tripsTomorrow, feed, CloudContextService.getNamespace());
        this._log.info("TripsIn2Days: {}, feed: {}, namespace: {}", tripsNextDay, feed, CloudContextService.getNamespace());
        this._log.info("TripsIn3Days: {}, feed: {}, namespace: {}", tripsDayAfterNext, feed, CloudContextService.getNamespace());
        if (tripsToday == 0) {
            this._log.error("Agency {} {} is missing service for today {}", agency, agencyName, tomorrow);
        }
        if (tripsTomorrow == 0) {
            this._log.error("Agency {} {} is missing service for tomorrow {}", agency, agencyName, tomorrow);
        }
        if (tripsNextDay == 0) {
            this._log.error("Agency {} {} is missing service for the day after tomorrow {}", agency, agencyName, nextDay);
        }
        if (tripsDayAfterNext == 0) {
            this._log.error("Agency {} {} is missing service in 3 days {}", agency, agencyName, dayAfterNext);
        }
    }

    int hasServiceForDate(GtfsMutableRelationalDao dao, Date testDate) {
        ServiceDate serviceDate = new ServiceDate(testDate);
        int numTripsOnDate = 0;
        for (Trip trip : dao.getAllTrips()) {
            if (!this.helper.isTripActive(dao, serviceDate, trip, false)) continue;
            ++numTripsOnDate;
        }
        return numTripsOnDate;
    }
}

