/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.File;
import java.util.List;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.InputLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddOmnyLIRRData
implements GtfsTransformStrategy {
    private static final int STOP_ID = 0;
    private static final int ZONE_ID = 1;
    private static Logger _log = LoggerFactory.getLogger(AddOmnyLIRRData.class);

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        int stop_count = 0;
        File stopsFile = new File((String)context.getParameter("omnyStopsFile"));
        if (!stopsFile.exists()) {
            throw new IllegalStateException("OMNY Stops file does not exist: " + stopsFile.getName());
        }
        List<String> stopLines = new InputLibrary().readList((String)context.getParameter("omnyStopsFile"));
        _log.info("Length of stop file: {}", (Object)stopLines.size());
        block0: for (String stopInfo : stopLines) {
            String[] stopArray = stopInfo.split(",");
            if (stopArray == null || stopArray.length < 2) {
                _log.info("bad line {}", (Object)stopInfo);
                continue;
            }
            String stopId = stopArray[0];
            String zoneId = stopArray[1];
            for (Stop stop : dao.getAllStops()) {
                if (!stop.getId().getId().equals(stopId)) continue;
                stop.setZoneId(zoneId);
                ++stop_count;
                continue block0;
            }
        }
        _log.info("Set {} stops with zone_id", (Object)stop_count);
    }
}

