/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.factory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.FareRule;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.collections.IdKey;
import org.onebusaway.gtfs_transformer.collections.ServiceIdKey;
import org.onebusaway.gtfs_transformer.collections.ShapeIdKey;

public class EntityRetentionGraph {
    private Set<Object> _retainedDown = new HashSet<Object>();
    private Set<Object> _retainedUp = new HashSet<Object>();
    private GtfsRelationalDao _dao;
    private boolean _retainBlocks = true;
    private boolean _retainAllStopTimesForTrip = true;

    public EntityRetentionGraph(GtfsRelationalDao dao) {
        this._dao = dao;
    }

    public void setRetainBlocks(boolean retainBlocks) {
        this._retainBlocks = retainBlocks;
    }

    public void setRetainAllStopTimesForTrip(boolean retainAllStopTimesForTrip) {
        this._retainAllStopTimesForTrip = retainAllStopTimesForTrip;
    }

    public void retainUp(Object object) {
        this.retain(object, true);
    }

    public void retainDown(Object object) {
        this.retain(object, false);
    }

    public void retain(Object object, boolean retainUp) {
        Set<Object> retained;
        if (object == null) {
            throw new IllegalArgumentException("object to retain is null");
        }
        Set<Object> set = retained = retainUp ? this._retainedUp : this._retainedDown;
        if (!retained.add(object)) {
            return;
        }
        if (object instanceof Agency) {
            this.retainAgency((Agency)object, retainUp);
        } else if (object instanceof Route) {
            this.retainRoute((Route)object, retainUp);
        } else if (object instanceof Trip) {
            this.retainTrip((Trip)object, retainUp);
        } else if (object instanceof StopTime) {
            this.retainStopTime((StopTime)object, retainUp);
        } else if (object instanceof Stop) {
            this.retainStop((Stop)object, retainUp);
        } else if (object instanceof ServiceCalendar) {
            this.retainServiceCalendar((ServiceCalendar)object, retainUp);
        } else if (object instanceof ServiceCalendarDate) {
            this.retainServiceCalendarDate((ServiceCalendarDate)object, retainUp);
        } else if (object instanceof ServiceIdKey) {
            this.retainServiceId(((ServiceIdKey)object).getId(), retainUp);
        } else if (object instanceof ShapeIdKey) {
            this.retainShapeId(((ShapeIdKey)object).getId(), retainUp);
        } else if (object instanceof BlockIdKey) {
            this.retainBlockId(((BlockIdKey)object).getId(), retainUp);
        } else if (object instanceof Frequency) {
            this.retainFrequency((Frequency)object, retainUp);
        } else if (object instanceof ZoneIdKey) {
            this.retainZoneId((ZoneIdKey)object, retainUp);
        } else if (object instanceof FareRule) {
            this.retainFareRule((FareRule)object, retainUp);
        } else if (object instanceof FareAttribute) {
            this.retainFareAttribute((FareAttribute)object, retainUp);
        }
        if (retainUp) {
            this.retainDown(object);
        }
    }

    public boolean isRetained(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object to check is null");
        }
        return this._retainedDown.contains(object);
    }

    public int getSize() {
        return this._retainedDown.size();
    }

    private void retainAgency(Agency agency, boolean retainUp) {
        if (retainUp) {
            for (Route route : this._dao.getRoutesForAgency(agency)) {
                this.retain(route, retainUp);
            }
        }
    }

    private void retainRoute(Route route, boolean retainUp) {
        if (retainUp) {
            for (Trip trip : this._dao.getTripsForRoute(route)) {
                this.retainUp(trip);
            }
            for (FareRule fareRule : this._dao.getFareRulesForRoute(route)) {
                this.retainUp(fareRule);
            }
        } else {
            this.retainDown(route.getAgency());
            for (FareRule rule : this._dao.getFareRulesForRoute(route)) {
                this.potentiallyRetainFareRuleDown(rule);
            }
        }
    }

    private void retainTrip(Trip trip, boolean retainUp) {
        if (retainUp) {
            for (StopTime stopTime : this._dao.getStopTimesForTrip(trip)) {
                this.retainUp(stopTime);
            }
            if (this._retainBlocks && trip.getBlockId() != null) {
                AgencyAndId blockId = new AgencyAndId(trip.getId().getAgencyId(), trip.getBlockId());
                this.retainUp(new BlockIdKey(blockId));
            }
            for (Frequency frequency : this._dao.getFrequenciesForTrip(trip)) {
                this.retainUp(frequency);
            }
        } else {
            this.retainDown(trip.getRoute());
            this.retainDown(new ServiceIdKey(trip.getServiceId()));
            AgencyAndId shapeId = trip.getShapeId();
            if (shapeId != null && shapeId.hasValues()) {
                this.retainDown(new ShapeIdKey(shapeId));
            }
        }
    }

    private void retainStopTime(StopTime stopTime, boolean retainUp) {
        if (!retainUp) {
            this.retainDown(stopTime.getStop());
            if (this._retainAllStopTimesForTrip) {
                this.retainUp(stopTime.getTrip());
            } else {
                this.retainDown(stopTime.getTrip());
            }
        }
    }

    private void retainStop(Stop stop, boolean retainUp) {
        if (retainUp) {
            for (StopTime stopTime : this._dao.getStopTimesForStop(stop)) {
                this.retainUp(stopTime);
            }
        } else {
            AgencyAndId stopId;
            String agencyId;
            Agency agency;
            String parentStationId = stop.getParentStation();
            if (parentStationId != null) {
                AgencyAndId id = stop.getId();
                Stop parent = this._dao.getStopForId(new AgencyAndId(id.getAgencyId(), parentStationId));
                this.retainDown(parent);
            }
            if (stop.getZoneId() != null) {
                this.retainDown(new ZoneIdKey(stop.getZoneId()));
            }
            if ((agency = this._dao.getAgencyForId(agencyId = (stopId = stop.getId()).getAgencyId())) != null) {
                this.retainDown(agency);
            }
        }
    }

    private void retainServiceCalendar(ServiceCalendar calendar, boolean retainUp) {
        if (retainUp) {
            this.retainUp(new ServiceIdKey(calendar.getServiceId()));
        }
    }

    private void retainServiceCalendarDate(ServiceCalendarDate calendarDate, boolean retainUp) {
        if (retainUp) {
            this.retainUp(new ServiceIdKey(calendarDate.getServiceId()));
        }
    }

    private void retainServiceId(AgencyAndId serviceId, boolean retainUp) {
        if (retainUp) {
            for (Trip trip : this._dao.getTripsForServiceId(serviceId)) {
                this.retainUp(trip);
            }
        } else {
            ServiceCalendar calendar = this._dao.getCalendarForServiceId(serviceId);
            if (calendar != null) {
                this.retainDown(calendar);
            }
            for (ServiceCalendarDate calendarDate : this._dao.getCalendarDatesForServiceId(serviceId)) {
                this.retainDown(calendarDate);
            }
            String agencyId = serviceId.getAgencyId();
            Agency agency = this._dao.getAgencyForId(agencyId);
            if (agency != null) {
                this.retainDown(agency);
            }
        }
    }

    private void retainShapeId(AgencyAndId shapeId, boolean retainUp) {
        if (!retainUp) {
            for (ShapePoint shapePoint : this._dao.getShapePointsForShapeId(shapeId)) {
                this.retainDown(shapePoint);
            }
            String agencyId = shapeId.getAgencyId();
            Agency agency = this._dao.getAgencyForId(agencyId);
            if (agency != null) {
                this.retainDown(agency);
            }
        }
    }

    private void retainBlockId(AgencyAndId blockId, boolean retainUp) {
        if (retainUp) {
            for (Trip trip : this._dao.getTripsForBlockId(blockId)) {
                this.retainUp(trip);
            }
        } else {
            for (Trip trip : this._dao.getTripsForBlockId(blockId)) {
                this.retainUp(trip);
            }
        }
    }

    private void retainFrequency(Frequency frequency, boolean retainUp) {
        if (!retainUp) {
            this.retainDown(frequency.getTrip());
        }
    }

    private void retainZoneId(ZoneIdKey key, boolean retainUp) {
        if (retainUp) {
            for (Stop stop : this._dao.getStopsForZoneId(key._zoneId)) {
                this.retainUp(stop);
            }
        } else {
            for (FareRule rule : this._dao.getFareRulesForZoneId(key._zoneId)) {
                this.potentiallyRetainFareRuleDown(rule);
            }
        }
    }

    private void retainFareRule(FareRule fareRule, boolean retainUp) {
        if (retainUp) {
            if (fareRule.getRoute() != null) {
                this.retainUp(fareRule.getRoute());
            }
            List<String> zoneIds = Arrays.asList(fareRule.getOriginId(), fareRule.getDestinationId(), fareRule.getContainsId());
            for (String zoneId : zoneIds) {
                if (zoneId == null) continue;
                this.retainUp(new ZoneIdKey(zoneId));
            }
        } else {
            if (fareRule.getFare() != null) {
                this.retainDown(fareRule.getFare());
            }
            if (fareRule.getRoute() != null) {
                this.retainDown(fareRule.getRoute());
            }
        }
    }

    private void potentiallyRetainFareRuleDown(FareRule rule) {
        if (this._retainedDown.contains(rule)) {
            return;
        }
        if (rule.getRoute() != null && !this._retainedDown.contains(rule.getRoute())) {
            return;
        }
        List<String> zoneIds = Arrays.asList(rule.getOriginId(), rule.getDestinationId(), rule.getContainsId());
        for (String zoneId : zoneIds) {
            if (zoneId == null || this._retainedDown.contains(new ZoneIdKey(zoneId))) continue;
            return;
        }
        this.retainDown(rule);
    }

    private void retainFareAttribute(FareAttribute fareAttribute, boolean retainUp) {
        Agency agency;
        if (retainUp) {
            for (FareRule rule : this._dao.getFareRulesForFareAttribute(fareAttribute)) {
                this.retainUp(rule);
            }
        } else if (fareAttribute.getAgencyId() != null && (agency = this._dao.getAgencyForId(fareAttribute.getAgencyId())) != null) {
            this.retainDown(agency);
        }
    }

    private static class ZoneIdKey {
        private final String _zoneId;

        public ZoneIdKey(String zoneId) {
            this._zoneId = zoneId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZoneIdKey zoneIdKey = (ZoneIdKey)o;
            return this._zoneId.equals(zoneIdKey._zoneId);
        }

        public int hashCode() {
            return Objects.hash(this._zoneId);
        }
    }

    private static class BlockIdKey
    extends IdKey {
        public BlockIdKey(AgencyAndId id) {
            super(id);
        }

        public String toString() {
            return "BlockIdKey(id=" + this._id + ")";
        }
    }
}

