/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.deferred;

import org.apache.commons.beanutils.Converter;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs_transformer.deferred.DeferredValueSupport;
import org.onebusaway.gtfs_transformer.deferred.EntitySchemaCache;
import org.onebusaway.gtfs_transformer.match.ValueMatcher;

public class DeferredValueMatcher
implements ValueMatcher {
    private final DeferredValueSupport _support;
    private final Object _value;
    private Object _resolvedValue = null;
    private boolean _resolvedValueSet = false;
    private Boolean isRegexObj = null;

    public DeferredValueMatcher(GtfsReader reader, EntitySchemaCache schemaCache, Object value) {
        this._support = new DeferredValueSupport(reader, schemaCache);
        this._value = value;
    }

    @Override
    public boolean matches(Class<?> parentEntityType, String propertyName, Object value) {
        Class<?> actualValueType;
        if (value == null) {
            return this._value == null;
        }
        if (this._value == null) {
            return false;
        }
        if (this._resolvedValueSet) {
            return value.equals(this._resolvedValue);
        }
        Class<?> expectedValueType = value.getClass();
        if (expectedValueType.isAssignableFrom(actualValueType = this._value.getClass())) {
            if (this.isRegexObj(this._value)) {
                return this.regexMatch((String)value, (String)this._value);
            }
            return value.equals(this._value);
        }
        if (actualValueType == String.class) {
            String actualValue = (String)this._value;
            if (expectedValueType == AgencyAndId.class) {
                AgencyAndId expectedId = (AgencyAndId)value;
                if (this.isRegexObj(this._value)) {
                    return this.regexMatch(expectedId.getId(), actualValue);
                }
                return expectedId.getId().equals(actualValue);
            }
            if (IdentityBean.class.isAssignableFrom(expectedValueType)) {
                IdentityBean bean = (IdentityBean)value;
                Object expectedId = bean.getId();
                if (expectedId == null) {
                    return false;
                }
                if (expectedId instanceof AgencyAndId) {
                    AgencyAndId expectedFullId = (AgencyAndId)expectedId;
                    return expectedFullId.getId().equals(actualValue);
                }
                if (expectedId instanceof String) {
                    return expectedId.equals(actualValue);
                }
            } else {
                Converter converter = this._support.resolveConverter(parentEntityType, propertyName, expectedValueType);
                if (converter != null) {
                    this._resolvedValue = converter.convert(expectedValueType, this._value);
                    this._resolvedValueSet = true;
                    return value.equals(this._resolvedValue);
                }
                throw new IllegalStateException("no type conversion from type String to type \"" + expectedValueType.getName() + "\" for value comparison");
            }
        }
        throw new IllegalStateException("no type conversion from type \"" + actualValueType.getName() + "\" to type \"" + expectedValueType.getName() + "\" for value comparison");
    }

    private boolean isRegexObj(Object value) {
        if (this.isRegexObj == null) {
            this.isRegexObj = this._value instanceof String && this.isRegex((String)this._value);
        }
        return this.isRegexObj;
    }

    private boolean isRegex(String pattern) {
        return pattern.startsWith("m/") && pattern.endsWith("/");
    }

    private String getRegexFromPattern(String pattern) {
        return pattern.substring(2, pattern.length() - 1);
    }

    private boolean regexMatch(String value, String pattern) {
        String regexPattern = this.getRegexFromPattern(pattern);
        boolean rc = value.matches(regexPattern);
        return rc;
    }
}

