/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.onebusaway.gtfs_transformer.GtfsTransformer;
import org.onebusaway.gtfs_transformer.GtfsTransformerLibrary;
import org.onebusaway.gtfs_transformer.TransformSpecificationException;
import org.onebusaway.gtfs_transformer.updates.EnsureStopTimesIncreaseUpdateStrategy;
import org.onebusaway.gtfs_transformer.updates.LocalVsExpressUpdateStrategy;
import org.onebusaway.gtfs_transformer.updates.RemoveDuplicateTripsStrategy;
import org.onebusaway.gtfs_transformer.updates.RemoveRepeatedStopTimesStrategy;
import org.onebusaway.gtfs_transformer.updates.TrivialStopTimeInterpolationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsTransformerMain {
    private static Logger _log = LoggerFactory.getLogger(GtfsTransformerMain.class);
    private static final String ARG_AGENCY_ID = "agencyId";
    private static final String ARG_MODIFICATIONS = "modifications";
    private static final String ARG_TRANSFORM = "transform";
    private static final String ARG_REFERENCE = "reference";
    private static final String ARG_STOP_MAPPING = "stopMapping";
    private static final String ARG_IGNORE_STOPS = "ignoreStops";
    private static final String ARG_REGEX_FILE = "regexFile";
    private static final String ARG_CONTROL_FILE = "controlFile";
    private static final String ARG_CONCURRENCY_FILE = "concurrencyFile";
    private static final String ARG_OMNY_ROUTES_FILE = "omnyRoutesFile";
    private static final String ARG_OMNY_STOPS_FILE = "omnyStopsFile";
    private static final String ARG_VERIFY_ROUTES_FILE = "verifyRoutesFile";
    private static final String ARG_LOCAL_VS_EXPRESS = "localVsExpress";
    private static final String ARG_CHECK_STOP_TIMES = "checkStopTimes";
    private static final String ARG_REMOVE_REPEATED_STOP_TIMES = "removeRepeatedStopTimes";
    private static final String INTERPOLATE_REPEATED_STOP_TIMES = "interpolateRepeatedStopTimes";
    private static final String ARG_REMOVE_DUPLICATE_TRIPS = "removeDuplicateTrips";
    private static final String ARG_OVERWRITE_DUPLICATES = "overwriteDuplicates";
    private static CommandLineParser _parser = new PosixParser();
    private Options _options = new Options();

    public static void main(String[] args) throws IOException {
        GtfsTransformerMain m = new GtfsTransformerMain();
        m.run(args);
    }

    public GtfsTransformerMain() {
        this.buildOptions(this._options);
    }

    public void run(String[] args) throws IOException {
        if (this.needsHelp(args)) {
            this.printHelp();
            System.exit(0);
        }
        try {
            CommandLine cli = _parser.parse(this._options, args, true);
            this.runApplication(cli, args);
        }
        catch (MissingOptionException ex) {
            System.err.println("Missing argument: " + ex.getMessage());
            this.printHelp();
            System.exit(-2);
        }
        catch (MissingArgumentException ex) {
            System.err.println("Missing argument: " + ex.getMessage());
            this.printHelp();
            System.exit(-2);
        }
        catch (UnrecognizedOptionException ex) {
            System.err.println("Unknown argument: " + ex.getMessage());
            this.printHelp();
            System.exit(-2);
        }
        catch (AlreadySelectedException ex) {
            System.err.println("Argument already selected: " + ex.getMessage());
            this.printHelp();
            System.exit(-2);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            this.printHelp();
            System.exit(-2);
        }
        catch (TransformSpecificationException ex) {
            System.err.println("error with transform line: " + ex.getLine());
            System.err.println(ex.getMessage());
            System.exit(-1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    protected void buildOptions(Options options) {
        options.addOption(ARG_AGENCY_ID, true, "agency id");
        options.addOption(ARG_MODIFICATIONS, true, "data modifications");
        options.addOption(ARG_TRANSFORM, true, "data transformation");
        options.addOption(ARG_REFERENCE, true, "reference GTFS to merge from");
        options.addOption(ARG_STOP_MAPPING, true, "Stop Name Mapping File");
        options.addOption(ARG_IGNORE_STOPS, true, "List of stops names to ignore");
        options.addOption(ARG_REGEX_FILE, true, "Regex pattern mapping file");
        options.addOption(ARG_CONTROL_FILE, true, "file to remap stop ids and other properties");
        options.addOption(ARG_CONCURRENCY_FILE, true, "file to remap wrong way concurrencies");
        options.addOption(ARG_OMNY_ROUTES_FILE, true, "file to add OMNY enabled routes to GTFS");
        options.addOption(ARG_OMNY_STOPS_FILE, true, "file to add OMNY enabled stops to GTFS");
        options.addOption(ARG_VERIFY_ROUTES_FILE, true, "file to check route names vs route ids in GTFS");
        options.addOption(ARG_LOCAL_VS_EXPRESS, false, "add additional local vs express fields");
        options.addOption(ARG_CHECK_STOP_TIMES, false, "check stop times are in order");
        options.addOption(ARG_REMOVE_REPEATED_STOP_TIMES, false, "remove repeated stop times");
        options.addOption(ARG_REMOVE_DUPLICATE_TRIPS, false, "remove duplicate trips");
        options.addOption(ARG_OVERWRITE_DUPLICATES, false, "overwrite duplicate elements");
    }

    protected void printHelp(PrintWriter out, Options options) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("usage.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = reader.readLine()) != null) {
            System.err.println(line);
        }
        reader.close();
    }

    protected void runApplication(CommandLine cli, String[] originalArgs) throws Exception {
        Option[] options;
        String[] args = cli.getArgs();
        if (args.length < 2) {
            this.printHelp();
            System.exit(-1);
        }
        ArrayList<File> paths = new ArrayList<File>();
        for (int i = 0; i < args.length - 1; ++i) {
            paths.add(new File(args[i]));
            _log.info("input path: " + args[i]);
        }
        GtfsTransformer transformer = new GtfsTransformer();
        transformer.setGtfsInputDirectories(paths);
        transformer.setOutputDirectory(new File(args[args.length - 1]));
        _log.info("output path: " + args[args.length - 1]);
        for (Option option : options = this.getOptionsInCommandLineOrder(cli, originalArgs)) {
            String name = option.getOpt();
            if (name.equals(ARG_REMOVE_REPEATED_STOP_TIMES)) {
                this.configureRemoveRepeatedStopTimes(transformer);
            }
            if (name.equals(INTERPOLATE_REPEATED_STOP_TIMES)) {
                this.configureInterpolateStopTimes(transformer);
            }
            if (name.equals(ARG_REMOVE_DUPLICATE_TRIPS)) {
                this.configureRemoveDuplicateTrips(transformer);
            }
            if (name.equals(ARG_CHECK_STOP_TIMES)) {
                this.configureEnsureStopTimesInOrder(transformer);
            }
            if (name.equals(ARG_AGENCY_ID)) {
                this.configureAgencyId(transformer, cli.getOptionValue(ARG_AGENCY_ID));
            }
            if (name.equals(ARG_MODIFICATIONS) || name.equals(ARG_TRANSFORM)) {
                GtfsTransformerLibrary.configureTransformation(transformer, option.getValue());
            }
            if (name.equals(ARG_REFERENCE)) {
                this.configureAdditionalGTFS(transformer, option.getValue());
            }
            if (name.equals(ARG_STOP_MAPPING)) {
                this.configureStopMapping(transformer, option.getValue());
            }
            if (name.equals(ARG_IGNORE_STOPS)) {
                this.configureIgnoreStops(transformer, option.getValue());
            }
            if (name.equals(ARG_REGEX_FILE)) {
                this.configureRegexFile(transformer, option.getValue());
            }
            if (name.equals(ARG_CONTROL_FILE)) {
                this.configureControlFile(transformer, option.getValue());
            }
            if (name.equals(ARG_CONCURRENCY_FILE)) {
                this.configureConcurrencyFile(transformer, option.getValue());
            }
            if (name.equals(ARG_OMNY_ROUTES_FILE)) {
                this.configureOmnyRoutesFile(transformer, option.getValue());
            }
            if (name.equals(ARG_OMNY_STOPS_FILE)) {
                this.configureOmnyStopsFile(transformer, option.getValue());
            }
            if (name.equals(ARG_VERIFY_ROUTES_FILE)) {
                this.configureVerifyRoutesFile(transformer, option.getValue());
            }
            if (name.equals(ARG_LOCAL_VS_EXPRESS)) {
                this.configureLocalVsExpressUpdates(transformer);
            }
            if (!name.equals(ARG_OVERWRITE_DUPLICATES)) continue;
            transformer.getReader().setOverwriteDuplicates(true);
        }
        transformer.run();
    }

    private Option[] getOptionsInCommandLineOrder(CommandLine cli, String[] originalArgs) {
        Option[] options = cli.getOptions();
        ArrayList<Ordered<Option>> orderedOptions = new ArrayList<Ordered<Option>>();
        for (Option option : options) {
            String argName = option.getOpt();
            int optionPosition = originalArgs.length;
            for (int i = 0; i < originalArgs.length; ++i) {
                if (!originalArgs[i].endsWith(argName)) continue;
                optionPosition = i;
                break;
            }
            orderedOptions.add(new Ordered<Option>(option, optionPosition));
        }
        Collections.sort(orderedOptions);
        options = new Option[options.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = (Option)((Ordered)orderedOptions.get(i)).getObject();
        }
        return options;
    }

    private void configureRemoveRepeatedStopTimes(GtfsTransformer updater) {
        updater.addTransform(new RemoveRepeatedStopTimesStrategy());
    }

    public void configureInterpolateStopTimes(GtfsTransformer updater) {
        updater.addTransform(new TrivialStopTimeInterpolationStrategy());
    }

    private void configureRemoveDuplicateTrips(GtfsTransformer updater) {
        updater.addTransform(new RemoveDuplicateTripsStrategy());
    }

    private void configureAgencyId(GtfsTransformer updater, String agencyId) {
        if (agencyId != null) {
            updater.setAgencyId(agencyId);
        }
    }

    private void configureEnsureStopTimesInOrder(GtfsTransformer updater) {
        updater.addTransform(new EnsureStopTimesIncreaseUpdateStrategy());
    }

    private void configureLocalVsExpressUpdates(GtfsTransformer updater) {
        updater.addTransform(new LocalVsExpressUpdateStrategy());
    }

    private void configureAdditionalGTFS(GtfsTransformer updater, String path) {
        updater.setGtfsReferenceDirectory(new File(path));
    }

    private void configureStopMapping(GtfsTransformer updater, String file) {
        updater.addParameter("stopMappingFile", file);
    }

    private void configureIgnoreStops(GtfsTransformer updater, String file) {
        updater.addParameter(ARG_IGNORE_STOPS, file);
    }

    private void configureRegexFile(GtfsTransformer updater, String file) {
        updater.addParameter(ARG_REGEX_FILE, file);
    }

    private void configureControlFile(GtfsTransformer updater, String file) {
        updater.addParameter(ARG_CONTROL_FILE, file);
    }

    private void configureConcurrencyFile(GtfsTransformer updater, String file) {
        updater.addParameter(ARG_CONCURRENCY_FILE, file);
    }

    private void configureOmnyRoutesFile(GtfsTransformer updater, String file) {
        updater.addParameter(ARG_OMNY_ROUTES_FILE, file);
    }

    private void configureOmnyStopsFile(GtfsTransformer updater, String file) {
        updater.addParameter(ARG_OMNY_STOPS_FILE, file);
    }

    private void configureVerifyRoutesFile(GtfsTransformer updater, String file) {
        updater.addParameter(ARG_VERIFY_ROUTES_FILE, file);
    }

    protected void printHelp() throws IOException {
        this.printHelp(new PrintWriter(System.err, true), this._options);
    }

    private boolean needsHelp(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-h") && !arg.equals("--help") && !arg.equals("-help")) continue;
            return true;
        }
        return false;
    }

    private static class Ordered<T>
    implements Comparable<Ordered<T>> {
        private T _object;
        private int _order;

        public Ordered(T object, int order) {
            this._object = object;
            this._order = order;
        }

        public T getObject() {
            return this._object;
        }

        @Override
        public int compareTo(Ordered<T> o) {
            return this._order - o._order;
        }
    }
}

