/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.gtfs.impl.GenericMutableDaoWrapper;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsWriter;
import org.onebusaway.gtfs.serialization.RouteWriter;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.factory.TransformFactory;
import org.onebusaway.gtfs_transformer.services.GtfsEntityTransformStrategy;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsTransformer {
    private static Logger _log = LoggerFactory.getLogger(GtfsTransformer.class);
    private List<File> _gtfsInputDirectories;
    private File _gtfsReferenceDirectory;
    private File _outputDirectory;
    private List<GtfsTransformStrategy> _transformStrategies = new ArrayList<GtfsTransformStrategy>();
    private List<GtfsEntityTransformStrategy> _entityTransformStrategies = new ArrayList<GtfsEntityTransformStrategy>();
    private TransformContext _context = new TransformContext();
    private GtfsReader _reader = new GtfsReader();
    private GtfsReader _referenceReader = new GtfsReader();
    private GtfsWriter _writer = new GtfsWriter();
    private RouteWriter _routeWriter = new RouteWriter();
    private GtfsMutableRelationalDao _dao = new GtfsRelationalDaoImpl();
    private String _agencyId;
    private Map<String, Object> _parameters = new HashMap<String, Object>();
    private TransformFactory _transformFactory = new TransformFactory(this);
    private boolean _writeZoneRouteMapping = false;
    private String _routeMappingOutputName = "ListOfRoutesInGtfs.txt";

    public void setGtfsInputDirectory(File gtfsInputDirectory) {
        this.setGtfsInputDirectories(Arrays.asList(gtfsInputDirectory));
    }

    public void setWriteZoneRouteMapping(boolean writeZoneRouteMapping) {
        this._writeZoneRouteMapping = writeZoneRouteMapping;
    }

    public void setRouteMappingOutputName(String routeMappingOutputName) {
        this._routeMappingOutputName = routeMappingOutputName;
    }

    public void setGtfsReferenceDirectory(File referenceDirectory) {
        this._gtfsReferenceDirectory = referenceDirectory;
    }

    public void setGtfsInputDirectories(List<File> paths) {
        this._gtfsInputDirectories = paths;
    }

    public void setOutputDirectory(File outputDirectory) {
        this._outputDirectory = outputDirectory;
    }

    public void addTransform(GtfsTransformStrategy strategy) {
        this._transformStrategies.add(strategy);
    }

    public List<GtfsTransformStrategy> getTransforms() {
        return this._transformStrategies;
    }

    public GtfsTransformStrategy getLastTransform() {
        if (this._transformStrategies.isEmpty()) {
            return null;
        }
        return this._transformStrategies.get(this._transformStrategies.size() - 1);
    }

    public void addEntityTransform(GtfsEntityTransformStrategy entityTransform) {
        this._entityTransformStrategies.add(entityTransform);
    }

    public void addParameter(String key, Object value) {
        this._parameters.put(key, value);
    }

    public void setAgencyId(String agencyId) {
        this._agencyId = agencyId;
    }

    public GtfsReader getReader() {
        return this._reader;
    }

    public GtfsReader getReferenceReader() {
        return this._referenceReader;
    }

    public GtfsWriter getWriter() {
        return this._writer;
    }

    public GtfsRelationalDao getDao() {
        return this._dao;
    }

    public TransformFactory getTransformFactory() {
        return this._transformFactory;
    }

    public void run() throws Exception {
        if (this._outputDirectory != null && !this._outputDirectory.exists() && !this._outputDirectory.getName().endsWith(".zip")) {
            this._outputDirectory.mkdirs();
        }
        for (String key : this._parameters.keySet()) {
            this._context.putParameter(key, this._parameters.get(key));
        }
        this.readGtfs();
        if (this._gtfsReferenceDirectory != null && this._gtfsReferenceDirectory.exists()) {
            this.readReferenceGtfs();
        } else {
            _log.trace("reference GTFS not found, continuing");
        }
        this._context.setDefaultAgencyId(this._reader.getDefaultAgencyId());
        this._context.setReader(this._reader);
        this.updateGtfs();
        this.writeGtfs();
        if (this._writeZoneRouteMapping) {
            this.writeRoutes();
        }
    }

    private void readGtfs() throws IOException {
        GenericMutableDao dao = this._dao;
        if (!this._entityTransformStrategies.isEmpty()) {
            dao = new DaoInterceptor(this._dao);
        }
        DefaultEntitySchemaFactory schemaFactory = new DefaultEntitySchemaFactory();
        schemaFactory.addFactory(GtfsEntitySchemaFactory.createEntitySchemaFactory());
        this._transformStrategies.forEach(s -> s.updateReadSchema(schemaFactory));
        this._reader.setEntitySchemaFactory(schemaFactory);
        this._reader.setEntityStore(dao);
        if (this._agencyId != null) {
            this._reader.setDefaultAgencyId(this._agencyId);
        }
        for (File path : this._gtfsInputDirectories) {
            FileTime fileTime;
            _log.info("reading gtfs from " + path);
            if (path.isFile() && (fileTime = (FileTime)Files.readAttributes(path.toPath(), "lastModifiedTime", new LinkOption[0]).get("lastModifiedTime")) != null) {
                _log.info("found lastModifiedTime of " + new Date(fileTime.toMillis()));
                this._reader.setLastModifiedTime(fileTime.toMillis());
            }
            this._reader.setInputLocation(path);
            this._reader.run();
        }
    }

    private void readReferenceGtfs() throws IOException {
        _log.info("reading reference GTFS at " + this._gtfsReferenceDirectory);
        GtfsRelationalDaoImpl dao = new GtfsRelationalDaoImpl();
        this._referenceReader.setEntityStore(dao);
        if (this._agencyId != null) {
            this._referenceReader.setDefaultAgencyId(this._agencyId);
        }
        this._referenceReader.setInputLocation(this._gtfsReferenceDirectory);
        this._referenceReader.run();
        this._context.setReferenceReader(this._referenceReader);
    }

    private void updateGtfs() {
        for (GtfsTransformStrategy strategy : this._transformStrategies) {
            String strategyName = strategy.toString();
            try {
                strategyName = strategy.getName();
            }
            catch (AbstractMethodError ame) {
                _log.info("(AbstractMethodError) strategy " + strategy + " does not support getName");
            }
            _log.info("Running strategy {} ....", (Object)strategyName);
            try {
                strategy.run(this._context, this._dao);
            }
            catch (Throwable t) {
                _log.error("Exception in strategy (v1) " + strategyName, t);
                throw new RuntimeException(t);
            }
            _log.info("Strategy {} complete.", (Object)strategyName);
        }
    }

    private void writeGtfs() throws IOException {
        if (this._outputDirectory == null) {
            return;
        }
        this._writer.setOutputLocation(this._outputDirectory);
        DefaultEntitySchemaFactory schemaFactory = new DefaultEntitySchemaFactory();
        schemaFactory.addFactory(GtfsEntitySchemaFactory.createEntitySchemaFactory());
        this._transformStrategies.forEach(s -> s.updateWriteSchema(schemaFactory));
        this._writer.setEntitySchemaFactory(schemaFactory);
        this._writer.run(this._dao);
        if (this._outputDirectory.isFile() && this._reader.getLastModfiedTime() != null) {
            _log.info("preserving lastModified time of " + new Date(this._reader.getLastModfiedTime()));
        }
    }

    private void writeRoutes() throws IOException {
        if (this._outputDirectory == null) {
            return;
        }
        this._routeWriter.setOutputLocation(this._outputDirectory);
        this._routeWriter.setRoutesOutputLocation(this._routeMappingOutputName);
        this._routeWriter.run(this._dao);
    }

    private class DaoInterceptor
    extends GenericMutableDaoWrapper {
        public DaoInterceptor(GenericMutableDao source) {
            super(source);
        }

        @Override
        public void saveEntity(Object entity) {
            for (GtfsEntityTransformStrategy strategy : GtfsTransformer.this._entityTransformStrategies) {
                entity = strategy.transformEntity(GtfsTransformer.this._context, GtfsTransformer.this._dao, entity);
                if (entity != null) continue;
                return;
            }
            super.saveEntity(entity);
        }
    }
}

