/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Location;
import org.onebusaway.gtfs.model.LocationGroup;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopArea;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;
import org.onebusaway.gtfs.serialization.mappings.EntityFieldMappingImpl;

public class StopLocationFieldMappingImpl
extends EntityFieldMappingImpl {
    public StopLocationFieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        super(entityType, csvFieldName, objFieldName, objFieldType, required);
    }

    @Override
    public Converter create(CsvEntityContext context) {
        GtfsReaderContext ctx = (GtfsReaderContext)context.get(GtfsReader.KEY_CONTEXT);
        return new ConverterImpl(ctx);
    }

    private class ConverterImpl
    implements Converter {
        private final GtfsReaderContext _context;

        public ConverterImpl(GtfsReaderContext context) {
            this._context = context;
        }

        @Override
        public Object convert(Class type, Object value) {
            if (type == String.class) {
                if (value instanceof String) {
                    return (String)value;
                }
                return null;
            }
            if (type == StopLocation.class) {
                String entityId = value.toString();
                String agencyId = this._context.getDefaultAgencyId();
                AgencyAndId id = new AgencyAndId(agencyId, entityId);
                Object stop = this._context.getEntity(Stop.class, id);
                if (stop != null) {
                    return stop;
                }
                Object location = this._context.getEntity(Location.class, id);
                if (location != null) {
                    return location;
                }
                Object locationGroup = this._context.getEntity(LocationGroup.class, id);
                if (locationGroup != null) {
                    return locationGroup;
                }
                Object stopArea = this._context.getEntity(StopArea.class, id);
                if (stopArea != null) {
                    return stopArea;
                }
                return null;
            }
            throw new ConversionException("Could not convert " + value + " of type " + value.getClass() + " to " + type);
        }
    }
}

