/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.util.List;
import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.exceptions.MissingRequiredFieldException;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;
import org.onebusaway.gtfs.serialization.mappings.AgencyNotFoundForRouteException;

public class RouteAgencyFieldMappingFactory
implements FieldMappingFactory {
    @Override
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new RouteAgencyFieldMapping(entityType, csvFieldName, objFieldName, Agency.class, required);
    }

    private class RouteAgencyFieldMapping
    extends AbstractFieldMapping {
        public RouteAgencyFieldMapping(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        @Override
        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            GtfsReaderContext ctx = (GtfsReaderContext)context.get(GtfsReader.KEY_CONTEXT);
            String agencyId = (String)csvValues.get(this._csvFieldName);
            Agency agency = null;
            if (this.isMissing(csvValues)) {
                List<Agency> agencies = ctx.getAgencies();
                if (agencies.isEmpty()) {
                    throw new AgencyNotFoundForRouteException(Route.class, object.getWrappedInstance(Route.class));
                }
                if (agencies.size() > 1) {
                    throw new MissingRequiredFieldException(this._entityType, this._csvFieldName);
                }
                agency = agencies.get(0);
            } else {
                agencyId = ctx.getTranslatedAgencyId(agencyId);
                for (Agency testAgency : ctx.getAgencies()) {
                    if (!testAgency.getId().equals(agencyId)) continue;
                    agency = testAgency;
                    break;
                }
                if (agency == null) {
                    throw new AgencyNotFoundForRouteException(Route.class, object.getWrappedInstance(Route.class), agencyId);
                }
            }
            object.setPropertyValue(this._objFieldName, agency);
        }

        @Override
        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            Agency agency = (Agency)object.getPropertyValue(this._objFieldName);
            if (this.isOptional() && agency == null) {
                return;
            }
            csvValues.put(this._csvFieldName, agency.getId());
        }
    }
}

