/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.csv_entities.schema.DefaultFieldMapping;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;

public class DefaultAgencyIdFieldMappingFactory
implements FieldMappingFactory {
    private String _agencyIdPath = null;

    public DefaultAgencyIdFieldMappingFactory() {
        this(null);
    }

    public DefaultAgencyIdFieldMappingFactory(String agencyIdPath) {
        this._agencyIdPath = agencyIdPath;
    }

    @Override
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new FieldMappingImpl(entityType, csvFieldName, objFieldName, String.class, required);
    }

    private class FieldMappingImpl
    extends DefaultFieldMapping {
        public FieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
            super(entityType, csvFieldName, objFieldName, objFieldType, required);
        }

        @Override
        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            if (this.isMissingAndOptional(object)) {
                return;
            }
            AgencyAndId id = (AgencyAndId)object.getPropertyValue(this._objFieldName);
            csvValues.put(this._csvFieldName, id.getId());
        }

        @Override
        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            String agencyId = this.resolveAgencyId(context, object);
            String id = (String)csvValues.get(this._csvFieldName);
            AgencyAndId agencyAndId = new AgencyAndId(agencyId, id);
            object.setPropertyValue(this._objFieldName, agencyAndId);
        }

        private String resolveAgencyId(CsvEntityContext context, BeanWrapper object) {
            if (DefaultAgencyIdFieldMappingFactory.this._agencyIdPath == null) {
                GtfsReaderContext ctx = (GtfsReaderContext)context.get(GtfsReader.KEY_CONTEXT);
                return ctx.getDefaultAgencyId();
            }
            for (String property : DefaultAgencyIdFieldMappingFactory.this._agencyIdPath.split("\\.")) {
                Object value = object.getPropertyValue(property);
                object = BeanWrapperFactory.wrap(value);
            }
            return object.getWrappedInstance(Object.class).toString();
        }
    }
}

