/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model.calendar;

import java.io.Serializable;

public final class ServiceInterval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int minArrival;
    private final int minDeparture;
    private final int maxArrival;
    private final int maxDeparture;

    public ServiceInterval(int arrival, int departure) {
        this(arrival, departure, arrival, departure);
    }

    public ServiceInterval(int minArrival, int minDeparture, int maxArrival, int maxDeparture) {
        this.minArrival = Math.min(minArrival, maxArrival);
        this.minDeparture = Math.min(minDeparture, maxDeparture);
        this.maxArrival = Math.max(minArrival, maxArrival);
        this.maxDeparture = Math.max(minDeparture, maxDeparture);
    }

    public int getMinArrival() {
        return this.minArrival;
    }

    public int getMinDeparture() {
        return this.minDeparture;
    }

    public int getMaxArrival() {
        return this.maxArrival;
    }

    public int getMaxDeparture() {
        return this.maxDeparture;
    }

    public ServiceInterval extend(int arrivalTime, int departureTime) {
        int minArrivalTime = Math.min(this.minArrival, arrivalTime);
        int minDepartureTime = Math.min(this.minDeparture, departureTime);
        int maxArrivalTime = Math.max(this.maxArrival, arrivalTime);
        int maxDepartureTime = Math.max(this.maxDeparture, departureTime);
        return new ServiceInterval(minArrivalTime, minDepartureTime, maxArrivalTime, maxDepartureTime);
    }

    public static ServiceInterval extend(ServiceInterval serviceInterval, int arrivalTime, int departureTime) {
        if (serviceInterval == null) {
            return new ServiceInterval(arrivalTime, departureTime);
        }
        return serviceInterval.extend(arrivalTime, departureTime);
    }

    public String toString() {
        return "Interval(min=" + this.minArrival + "," + this.minDeparture + " max=" + this.maxArrival + "," + this.maxDeparture + ")";
    }
}

