/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl.calendar;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;

public abstract class ServiceIdOp
implements Comparator<Date> {
    public static final ServiceIdOp ARRIVAL_OP = new ArrivalsServiceDateTimeOp();
    public static final ServiceIdOp DEPARTURE_OP = new DeparturesServiceDateTimeOp();
    public static final ServiceIdOp BOTH_OP = new MaxRangeServiceDateTimeOp();
    private boolean _reverse;

    protected ServiceIdOp(boolean reverse) {
        this._reverse = reverse;
    }

    public abstract int getFromTime(ServiceInterval var1);

    public abstract int getToTime(ServiceInterval var1);

    public abstract Date getServiceDate(List<Date> var1, int var2);

    @Override
    public int compare(Date a, Date b) {
        int rc = a.compareTo(b);
        if (this._reverse) {
            rc = -rc;
        }
        return rc;
    }

    public Date shiftTime(ServiceInterval interval, Date time) {
        long offset = this.getFromTime(interval) * 1000;
        return new Date(time.getTime() - offset);
    }

    public int compareInterval(ServiceInterval interval, Date serviceDate, Date from, Date to) {
        long serviceFrom = serviceDate.getTime() + (long)(this.getFromTime(interval) * 1000);
        long serviceTo = serviceDate.getTime() + (long)(this.getToTime(interval) * 1000);
        if (this._reverse) {
            if (serviceTo >= from.getTime()) {
                return -1;
            }
            if (to.getTime() >= serviceFrom) {
                return 1;
            }
            return 0;
        }
        if (serviceTo <= from.getTime()) {
            return -1;
        }
        if (to.getTime() <= serviceFrom) {
            return 1;
        }
        return 0;
    }

    private static class MaxRangeServiceDateTimeOp
    extends ServiceIdOp {
        protected MaxRangeServiceDateTimeOp() {
            super(false);
        }

        @Override
        public int getFromTime(ServiceInterval interval) {
            return Math.min(interval.getMinDeparture(), interval.getMinArrival());
        }

        @Override
        public int getToTime(ServiceInterval interval) {
            return Math.max(interval.getMaxDeparture(), interval.getMaxArrival());
        }

        @Override
        public Date getServiceDate(List<Date> data, int index) {
            return data.get(index);
        }
    }

    private static class DeparturesServiceDateTimeOp
    extends ServiceIdOp {
        protected DeparturesServiceDateTimeOp() {
            super(false);
        }

        @Override
        public int getFromTime(ServiceInterval interval) {
            return interval.getMinDeparture();
        }

        @Override
        public int getToTime(ServiceInterval interval) {
            return interval.getMaxDeparture();
        }

        @Override
        public Date getServiceDate(List<Date> data, int index) {
            return data.get(index);
        }
    }

    private static class ArrivalsServiceDateTimeOp
    extends ServiceIdOp {
        protected ArrivalsServiceDateTimeOp() {
            super(true);
        }

        @Override
        public int getFromTime(ServiceInterval interval) {
            return interval.getMaxArrival();
        }

        @Override
        public int getToTime(ServiceInterval interval) {
            return interval.getMinArrival();
        }

        @Override
        public Date getServiceDate(List<Date> data, int index) {
            return data.get(data.size() - 1 - index);
        }
    }
}

