/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections.combinations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.onebusaway.collections.combinations.CombinationIterator;
import org.onebusaway.collections.combinations.PermutationIterator;
import org.onebusaway.collections.combinations.SequentialPairIterator;
import org.onebusaway.collections.tuple.Pair;

public abstract class Combinations {
    public static <T> Iterable<Pair<T>> getCombinationsReflexive(Iterable<T> objects) {
        return Combinations.getCombinations(objects, true);
    }

    public static <T> Iterable<Pair<T>> getCombinationsNonReflexive(Iterable<T> objects) {
        return Combinations.getCombinations(objects, false);
    }

    public static <T> Iterable<Pair<T>> getCombinations(Iterable<T> objects, boolean includeReflexive) {
        ArrayList<T> elements = new ArrayList<T>();
        for (T element : objects) {
            elements.add(element);
        }
        return new CombinationsIterable(elements, includeReflexive);
    }

    public static <T> Iterable<Pair<T>> getPermutations(final Iterable<T> objects) {
        return new Iterable<Pair<T>>(){

            @Override
            public Iterator<Pair<T>> iterator() {
                return new PermutationIterator(objects);
            }
        };
    }

    public static <T> Iterable<Pair<T>> getPermutations(final Iterable<T> objectsA, final Iterable<T> objectsB) {
        return new Iterable<Pair<T>>(){

            @Override
            public Iterator<Pair<T>> iterator() {
                return new PermutationIterator(objectsA, objectsB);
            }
        };
    }

    public static <T> Iterable<Pair<T>> getSequentialPairs(final Iterable<T> objects) {
        return new Iterable<Pair<T>>(){

            @Override
            public Iterator<Pair<T>> iterator() {
                return new SequentialPairIterator(objects);
            }
        };
    }

    public static <T> List<List<T>> getGroupCombinations(List<T> elements, int groupSize) {
        if (groupSize > elements.size()) {
            throw new IllegalStateException("group size is larger than number of available elements");
        }
        ArrayList<List<T>> lists = new ArrayList<List<T>>();
        ArrayList current = new ArrayList();
        Combinations.getGroupCombinations(elements, groupSize, 0, lists, current);
        return lists;
    }

    private static <T> void getGroupCombinations(List<T> elements, int groupSize, int index, List<List<T>> lists, List<T> current) {
        if (current.size() == groupSize) {
            lists.add(current);
            return;
        }
        int g = groupSize - current.size();
        for (int i = index; i < elements.size() - g + 1; ++i) {
            ArrayList<T> c = new ArrayList<T>(current.size() + 1);
            c.addAll(current);
            c.add(elements.get(i));
            Combinations.getGroupCombinations(elements, groupSize, i + 1, lists, c);
        }
    }

    private static class CombinationsIterable<T>
    implements Iterable<Pair<T>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<T> _elements;
        private boolean _includeReflexive;

        public CombinationsIterable(List<T> elements, boolean includeReflexive) {
            this._elements = elements;
            this._includeReflexive = includeReflexive;
        }

        @Override
        public Iterator<Pair<T>> iterator() {
            return new CombinationIterator<T>(this._elements, this._includeReflexive);
        }
    }
}

