/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections.combinations;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.onebusaway.collections.tuple.Pair;
import org.onebusaway.collections.tuple.Tuples;

class CombinationIterator<T>
implements Iterator<Pair<T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> _readings;
    private boolean _includeReflexive;
    private int _indexI = 0;
    private int _indexJ = 0;
    private Pair<T> _next = null;

    public CombinationIterator(List<T> readings, boolean includeReflexive) {
        this._readings = readings;
        this._includeReflexive = includeReflexive;
        this._indexI = 0;
        this._indexJ = this._includeReflexive ? this._indexI : this._indexI + 1;
        this.tryNext();
    }

    @Override
    public boolean hasNext() {
        return this._next != null;
    }

    @Override
    public Pair<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<T> n = this._next;
        this.tryNext();
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void tryNext() {
        if (this._indexI < this._readings.size() && this._indexJ < this._readings.size()) {
            this._next = Tuples.pair(this._readings.get(this._indexI), this._readings.get(this._indexJ));
            ++this._indexJ;
            if (this._indexJ >= this._readings.size()) {
                ++this._indexI;
                this._indexJ = this._includeReflexive ? this._indexI : this._indexI + 1;
            }
        } else {
            this._next = null;
        }
    }
}

