/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.onebusaway.collections.beans.DefaultPropertyMethodResolver;
import org.onebusaway.collections.beans.PropertyInvocationResult;
import org.onebusaway.collections.beans.PropertyMethod;
import org.onebusaway.collections.beans.PropertyMethodResolver;

public final class PropertyPathCollectionExpression {
    private String[] _properties;
    private PropertyMethod[] _methods = null;
    private PropertyMethodResolver _resolver = new DefaultPropertyMethodResolver();

    public static void evaluate(Object target, String query, Collection<Object> values) {
        PropertyPathCollectionExpression expression = new PropertyPathCollectionExpression(query);
        expression.invoke(target, values);
    }

    public static List<Object> evaluate(Object target, String query) {
        PropertyPathCollectionExpression expression = new PropertyPathCollectionExpression(query);
        ArrayList<Object> values = new ArrayList<Object>();
        expression.invoke(target, values);
        return values;
    }

    public PropertyPathCollectionExpression(String query) {
        this._properties = query.split("\\.");
        this._methods = new PropertyMethod[this._properties.length];
    }

    public void setPropertyMethodResolver(PropertyMethodResolver resolver) {
        this._resolver = resolver;
    }

    public String getPath() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this._properties.length; ++i) {
            if (i > 0) {
                b.append('.');
            }
            b.append(this._properties[i]);
        }
        return b.toString();
    }

    public void invoke(Object value, Collection<Object> results) {
        this.invoke(null, value, 0, new ValueResultCollector(results));
    }

    public void invokeReturningFullResult(Object value, Collection<PropertyInvocationResult> results) {
        this.invoke(null, value, 0, new FullResultCollector(results));
    }

    private void invoke(Object parent, Object value, int methodIndex, ResultCollector collector) {
        if (methodIndex == this._methods.length) {
            String propertyName = this._properties.length == 0 ? null : this._properties[this._properties.length - 1];
            collector.addResult(parent, propertyName, value);
            return;
        }
        if (value == null) {
            return;
        }
        PropertyMethod m = this.getPropertyMethod(value.getClass(), methodIndex);
        Object result = null;
        try {
            result = m.invoke(value);
        }
        catch (Exception ex) {
            throw new IllegalStateException("error invoking property reader: obj=" + value + " property=" + this._properties[methodIndex], ex);
        }
        if (result instanceof Iterable) {
            Iterable iterable = (Iterable)result;
            for (Object child : iterable) {
                this.invoke(value, child, methodIndex + 1, collector);
            }
        } else if (result instanceof Object[]) {
            Object[] values;
            for (Object child : values = (Object[])result) {
                this.invoke(value, child, methodIndex + 1, collector);
            }
        } else {
            this.invoke(value, result, methodIndex + 1, collector);
        }
    }

    private PropertyMethod getPropertyMethod(Class<?> valueType, int methodIndex) {
        PropertyMethod method = this._methods[methodIndex];
        if (method == null) {
            this._methods[methodIndex] = method = this._resolver.getPropertyMethod(valueType, this._properties[methodIndex]);
        }
        return method;
    }

    private static class FullResultCollector
    implements ResultCollector {
        private final Collection<PropertyInvocationResult> results;

        public FullResultCollector(Collection<PropertyInvocationResult> results) {
            this.results = results;
        }

        @Override
        public void addResult(Object parent, String propertyName, Object value) {
            this.results.add(new PropertyInvocationResult(parent, propertyName, value));
        }
    }

    private static class ValueResultCollector
    implements ResultCollector {
        private final Collection<Object> values;

        public ValueResultCollector(Collection<Object> values) {
            this.values = values;
        }

        @Override
        public void addResult(Object parent, String propertyName, Object value) {
            this.values.add(value);
        }
    }

    private static interface ResultCollector {
        public void addResult(Object var1, String var2, Object var3);
    }
}

