/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.collections.beans.PropertyPathExpression;

public class MappingLibrary {
    public static <T1, T2> List<T2> map(Iterable<T1> values, String propertyPathExpression) {
        ArrayList<Object> mappedValues = new ArrayList<Object>();
        PropertyPathExpression query = new PropertyPathExpression(propertyPathExpression);
        for (T1 value : values) {
            mappedValues.add(query.invoke(value));
        }
        return mappedValues;
    }

    public static <T1, T2> List<T2> map(Iterable<T1> values, String propertyPathExpression, Class<T2> resultType) {
        return MappingLibrary.map(values, propertyPathExpression);
    }

    public static <K, V> Map<K, V> mapToValue(Iterable<V> values, String propertyPathExpression) {
        HashMap<Object, V> byKey = new HashMap<Object, V>();
        PropertyPathExpression query = new PropertyPathExpression(propertyPathExpression);
        for (V value : values) {
            Object key = query.invoke(value);
            byKey.put(key, value);
        }
        return byKey;
    }

    public static <K, V> Map<K, V> mapToValue(Iterable<V> values, String property, Class<K> keyType) {
        return MappingLibrary.mapToValue(values, property);
    }

    public static <K, V> Map<K, List<V>> mapToValueList(Iterable<V> values, String property) {
        return MappingLibrary.mapToValueCollection(values, property, new ArrayList().getClass());
    }

    public static <K, V> Map<K, List<V>> mapToValueList(Iterable<V> values, String property, Class<K> keyType) {
        return MappingLibrary.mapToValueCollection(values, property, new ArrayList().getClass());
    }

    public static <K, V> Map<K, Set<V>> mapToValueSet(Iterable<V> values, String property) {
        return MappingLibrary.mapToValueCollection(values, property, new HashSet().getClass());
    }

    public static <K, V, C extends Collection<V>, CIMPL extends C> Map<K, C> mapToValueCollection(Iterable<V> values, String property, Class<CIMPL> collectionType) {
        HashMap<Object, Collection> byKey = new HashMap<Object, Collection>();
        PropertyPathExpression query = new PropertyPathExpression(property);
        for (V value : values) {
            Object key = query.invoke(value);
            Collection valuesForKey = (Collection)byKey.get(key);
            if (valuesForKey == null) {
                try {
                    valuesForKey = (Collection)collectionType.newInstance();
                }
                catch (Exception ex) {
                    throw new IllegalStateException("error instantiating collection type: " + collectionType, ex);
                }
                byKey.put(key, valuesForKey);
            }
            valuesForKey.add(value);
        }
        return byKey;
    }
}

