/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.cloud.noop;

import java.util.List;
import org.onebusaway.cloud.api.Credential;
import org.onebusaway.cloud.api.ExternalResult;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.InputStreamConsumer;
import org.onebusaway.cloud.noop.AlwaysTrueExternalResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalServicesNoopImpl
implements ExternalServices {
    private final Logger _log = LoggerFactory.getLogger(ExternalServicesNoopImpl.class);

    @Override
    public ExternalResult publishMessage(String topic, String messageContents) {
        this._log.info("publishMessage({" + topic + "}, {" + messageContents + "})");
        return new AlwaysTrueExternalResult();
    }

    @Override
    public ExternalResult publishMetric(String topic, String metricName, String dimensionName, String dimensionValue, double value) {
        this._log.info("publishMetric({" + topic + ":" + metricName + "}, {" + dimensionName + "=" + dimensionValue + "}, {" + value + "})");
        return new AlwaysTrueExternalResult();
    }

    @Override
    public ExternalResult publishMetric(Credential credential, String namespace, String metricName, String dimensionName, String dimensionValue, double value) {
        this._log.info("publishMetric({" + namespace + ":" + metricName + "}, {" + dimensionName + "=" + dimensionValue + "}, {" + value + "})");
        return new AlwaysTrueExternalResult();
    }

    @Override
    public ExternalResult publishMetrics(String topic, List<String> metricNames, List<String> dimensionNames, List<String> dimensionValues, List<Double> values) {
        StringBuilder sb = new StringBuilder();
        sb.append("publishMetrics({");
        sb.append("topic=").append(topic);
        if (metricNames != null) {
            sb.append(", metricNames=[");
            for (String metricName : metricNames) {
                sb.append("metricName").append(",");
            }
            sb.append("],");
        }
        if (values != null) {
            sb.append(", values=[");
            for (Double value : values) {
                sb.append(value).append(",");
            }
            sb.append("]");
        }
        if (dimensionNames != null) {
            sb.append(", dimensionNames=[");
            for (String dnames : dimensionNames) {
                sb.append(dnames).append(",");
            }
            sb.append("]");
        }
        if (dimensionValues != null) {
            sb.append(", dimensionValues=[");
            for (String dvalues : dimensionValues) {
                sb.append(dvalues).append(",");
            }
            sb.append("]");
        }
        sb.append("})");
        this._log.info(sb.toString());
        return new AlwaysTrueExternalResult();
    }

    @Override
    public ExternalResult publishMetrics(Credential credential, String namespace, List<String> metricNames, List<String> dimensionNames, List<String> dimensionValues, List<Double> values) {
        return this.publishMetrics(namespace, metricNames, dimensionNames, dimensionValues, values);
    }

    @Override
    public ExternalResult publishMultiDimensionalMetric(String topic, String metricName, String[] dimensionName, String[] dimensionValue, double value) {
        this._log.info("publishMetric({" + topic + ":" + metricName + "}, {" + dimensionName + "=" + dimensionValue + "}, {" + value + "})");
        return new AlwaysTrueExternalResult();
    }

    @Override
    public ExternalResult publishMultiDimensionalMetric(Credential credential, String namespace, String metricName, String[] dimensionName, String[] dimensionValue, double value) {
        return this.publishMultiDimensionalMetric(namespace, metricName, dimensionName, dimensionValue, value);
    }

    @Override
    public ExternalResult getFileAsStream(String url, InputStreamConsumer callback, String profile) {
        this._log.info("getFileAsStream({" + url + "}, " + profile + " }");
        return new AlwaysTrueExternalResult();
    }

    @Override
    public ExternalResult getFileAsStream(String url, InputStreamConsumer callback, String profile, String region) {
        this._log.info("getFileAsStream({" + url + "}, " + profile + ", " + region + "}");
        return new AlwaysTrueExternalResult();
    }

    @Override
    public ExternalResult getFileAsStream(String url, InputStreamConsumer callback) {
        this._log.info("getFileAsStream({" + url + " }");
        return new AlwaysTrueExternalResult();
    }

    @Override
    public ExternalResult putFile(String url, String file, String profile, String region) {
        this._log.info("putFile({" + url + " } from " + file);
        return new AlwaysTrueExternalResult();
    }

    @Override
    public ExternalResult putFile(String url, String file) {
        this._log.info("putFile({" + url + " } from " + file);
        return new AlwaysTrueExternalResult();
    }

    @Override
    public boolean isInstancePrimary() {
        return true;
    }
}

