/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.cloud.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalServicesBridgeFactory {
    private final Logger _log = LoggerFactory.getLogger(ExternalServicesBridgeFactory.class);
    public static final String AWS_KEY = "oba.cloud.aws";
    private static final String NOOP_FACTORY = "org.onebusaway.cloud.noop.ExternalServicesNoopFactory";
    private static final String AWS_FACTORY = "org.onebusaway.cloud.aws.ExternalServicesAwsFactory";

    public ExternalServices getExternalServices() {
        ExternalServices es;
        if (this.getPropertySet(AWS_KEY) && (es = this.instantiate(AWS_FACTORY)) != null) {
            return es;
        }
        return this.instantiate(NOOP_FACTORY);
    }

    private boolean getPropertySet(String key) {
        return "true".equalsIgnoreCase(System.getProperty(key));
    }

    private ExternalServices instantiate(String className) {
        Class<?> factoryClass = null;
        try {
            factoryClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.reportException(className, e);
            return null;
        }
        Constructor<?> factoryConstructor = null;
        try {
            factoryConstructor = factoryClass.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            this.reportException(className, e);
            return null;
        }
        Object obj = null;
        try {
            obj = factoryConstructor.newInstance(null);
        }
        catch (InstantiationException e) {
            this.reportException(className, e);
            return null;
        }
        catch (IllegalAccessException e) {
            this.reportException(className, e);
            return null;
        }
        catch (InvocationTargetException e) {
            this.reportException(className, e);
            return null;
        }
        ExternalServicesFactory esf = obj;
        return esf.getExternalServices();
    }

    private void reportException(String className, Exception e) {
        this._log.info("Exception instantiating " + className, e);
    }
}

