/*
 * Decompiled with CFR 0.152.
 */
package net.transitdata.siri;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Util {
    JAXBContext jc;
    DatatypeFactory df = null;
    Schema schema = null;
    String xmlPath = "xsd/siriSg.xsd";
    String schemaName = "uk.org.siri.siri";

    public String getJSONFromObject(Object o, boolean format) {
        String json = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.INDENT_OUTPUT, format);
            AnnotationIntrospectorPair aipair = new AnnotationIntrospectorPair((AnnotationIntrospector)new JaxbAnnotationIntrospector(), (AnnotationIntrospector)new JacksonAnnotationIntrospector());
            mapper.setAnnotationIntrospector((AnnotationIntrospector)aipair);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            json = mapper.writeValueAsString(o);
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return json;
    }

    public String getXMLFromObject(Object o, boolean format) {
        StringWriter wrtr = new StringWriter();
        String xml = null;
        try {
            this.jc = JAXBContext.newInstance((String)this.schemaName);
            Marshaller m = this.jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)new Boolean(format));
            m.marshal(o, (Writer)wrtr);
            xml = wrtr.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return xml;
    }

    public void validateXML(String xml) {
        String schemaFile = this.xmlPath;
        File file = new File(schemaFile);
        URL schemaUrl = null;
        try {
            schemaUrl = file.toURI().toURL();
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
        System.out.println("SCHEMA FILE URL: " + schemaUrl);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException saxe) {
            this.schema = null;
            saxe.printStackTrace();
        }
        try {
            this.jc = JAXBContext.newInstance((String)this.schemaName);
            System.out.println("loaded xml");
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        try {
            this.df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e1) {
            e1.printStackTrace();
        }
        Validator v = this.schema.newValidator();
        v.setErrorHandler(new ForgivingErrorHandler());
        try {
            v.validate(new StreamSource(new ByteArrayInputStream(xml.getBytes())));
            System.out.println("Done");
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(6553400);
        System.out.println(filePath);
        InputStream is = this.getClass().getResourceAsStream(filePath);
        System.out.println(is);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader reader = new BufferedReader(isr);
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    public class ForgivingErrorHandler
    implements ErrorHandler {
        @Override
        public void warning(SAXParseException ex) {
            System.err.println(ex.getMessage());
        }

        @Override
        public void error(SAXParseException ex) {
            System.err.println(ex.getMessage());
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }
    }
}

