/*
 * Decompiled with CFR 0.152.
 */
package net.transitdata.siri;

import java.math.BigDecimal;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.validation.Schema;
import net.transitdata.siri.Util;
import uk.org.siri.siri_2.AnnotatedStopPointStructure;
import uk.org.siri.siri_2.DirectionRefStructure;
import uk.org.siri.siri_2.LineDirectionStructure;
import uk.org.siri.siri_2.LineRefStructure;
import uk.org.siri.siri_2.LocationStructure;
import uk.org.siri.siri_2.NaturalLanguageStringStructure;
import uk.org.siri.siri_2.Siri;
import uk.org.siri.siri_2.StopPointRefStructure;
import uk.org.siri.siri_2.StopPointsDeliveryStructure;

public class NewStopPointsDiscovery {
    JAXBContext jc;
    DatatypeFactory df = null;
    Schema schema = null;

    public static void main(String[] args) {
        NewStopPointsDiscovery nspd = new NewStopPointsDiscovery();
        Util ut = new Util();
        StopPointsDeliveryStructure spds = nspd.getStopPointsRequest();
        Siri siri = new Siri();
        siri.setStopPointsDelivery(spds);
        String xml = ut.getXMLFromObject(siri, true);
        System.out.println("XML:\n" + xml);
        ut.validateXML(xml);
    }

    private StopPointsDeliveryStructure getStopPointsRequest() {
        try {
            this.df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e1) {
            e1.printStackTrace();
        }
        StopPointsDeliveryStructure spds = new StopPointsDeliveryStructure();
        NaturalLanguageStringStructure stopName = new NaturalLanguageStringStructure();
        stopName.setValue("Stop A");
        DirectionRefStructure direction0 = new DirectionRefStructure();
        direction0.setValue("0");
        DirectionRefStructure direction1 = new DirectionRefStructure();
        direction1.setValue("1");
        LineRefStructure line1 = new LineRefStructure();
        line1.setValue("Agency_1");
        LineDirectionStructure lineDirStruct1 = new LineDirectionStructure();
        lineDirStruct1.setDirectionRef(direction0);
        lineDirStruct1.setLineRef(line1);
        LineRefStructure line2 = new LineRefStructure();
        line2.setValue("Agency_2");
        LineDirectionStructure lineDirStruct2 = new LineDirectionStructure();
        lineDirStruct2.setDirectionRef(direction1);
        lineDirStruct2.setLineRef(line2);
        AnnotatedStopPointStructure.Lines lines = new AnnotatedStopPointStructure.Lines();
        lines.getLineRefOrLineDirection().add(lineDirStruct1);
        lines.getLineRefOrLineDirection().add(lineDirStruct2);
        BigDecimal stopLat = new BigDecimal(44.12345);
        BigDecimal stopLon = new BigDecimal(-74.12345);
        LocationStructure location = new LocationStructure();
        location.setLongitude(stopLon);
        location.setLatitude(stopLat);
        AnnotatedStopPointStructure asps = new AnnotatedStopPointStructure();
        StopPointRefStructure spr = new StopPointRefStructure();
        spr.setValue("Agency_1234");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        XMLGregorianCalendar nowTime = this.df.newXMLGregorianCalendar(gregorianCalendar);
        spds.setResponseTimestamp(nowTime);
        asps.getStopName().add(stopName);
        asps.setLocation(location);
        asps.setLines(lines);
        asps.setMonitored(true);
        asps.setStopPointRef(spr);
        spds.getAnnotatedStopPointRef().add(asps);
        return spds;
    }
}

