/*
 * Decompiled with CFR 0.152.
 */
package net.transitdata.siri;

import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.validation.Schema;
import net.transitdata.siri.Util;
import uk.org.siri.siri_2.DataFrameRefStructure;
import uk.org.siri.siri_2.DirectionRefStructure;
import uk.org.siri.siri_2.FramedVehicleJourneyRefStructure;
import uk.org.siri.siri_2.JourneyPatternRefStructure;
import uk.org.siri.siri_2.JourneyPlaceRefStructure;
import uk.org.siri.siri_2.LineRefStructure;
import uk.org.siri.siri_2.MonitoredCallStructure;
import uk.org.siri.siri_2.MonitoredStopVisitStructure;
import uk.org.siri.siri_2.MonitoredVehicleJourneyStructure;
import uk.org.siri.siri_2.NaturalLanguageStringStructure;
import uk.org.siri.siri_2.OnwardCallStructure;
import uk.org.siri.siri_2.OnwardCallsStructure;
import uk.org.siri.siri_2.OperatorRefStructure;
import uk.org.siri.siri_2.ProgressRateEnumeration;
import uk.org.siri.siri_2.ServiceDelivery;
import uk.org.siri.siri_2.StopMonitoringDeliveryStructure;
import uk.org.siri.siri_2.StopPointRefStructure;

public class NewStopMonitoring {
    JAXBContext jc;
    DatatypeFactory df = null;
    Schema schema = null;

    public static void main(String[] args) {
        NewStopMonitoring nsm = new NewStopMonitoring();
        Util ut = new Util();
        String detailLevel = new String();
        detailLevel = "calls";
        ServiceDelivery sm = nsm.getStopMonitoring(detailLevel);
        String xml = ut.getXMLFromObject(sm, true);
        String json = ut.getJSONFromObject(sm, true);
        System.out.println("XML:\n" + xml);
        ut.validateXML(xml);
    }

    public ServiceDelivery getStopMonitoring(String detailLevel) {
        try {
            this.df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e1) {
            e1.printStackTrace();
        }
        ServiceDelivery sd = new ServiceDelivery();
        StopMonitoringDeliveryStructure smds = new StopMonitoringDeliveryStructure();
        MonitoredStopVisitStructure msv = new MonitoredStopVisitStructure();
        MonitoredVehicleJourneyStructure mvj = new MonitoredVehicleJourneyStructure();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        XMLGregorianCalendar nowTime = this.df.newXMLGregorianCalendar(gregorianCalendar);
        MonitoredCallStructure mc = new MonitoredCallStructure();
        StopPointRefStructure stoprefA = new StopPointRefStructure();
        stoprefA.setValue("OperatorA_1234");
        NaturalLanguageStringStructure stopnameA = new NaturalLanguageStringStructure();
        stopnameA.setValue("Stop A");
        StopPointRefStructure stoprefB = new StopPointRefStructure();
        stoprefB.setValue("OperatorA_1235");
        NaturalLanguageStringStructure stopnameB = new NaturalLanguageStringStructure();
        stopnameB.setValue("Stop B");
        gregorianCalendar.add(12, 1);
        XMLGregorianCalendar arrtime = this.df.newXMLGregorianCalendar(gregorianCalendar);
        gregorianCalendar.add(12, 1);
        XMLGregorianCalendar arrtime2 = this.df.newXMLGregorianCalendar(gregorianCalendar);
        LineRefStructure line = new LineRefStructure();
        line.setValue("OperatorA_Line123");
        DirectionRefStructure dr = new DirectionRefStructure();
        dr.setValue("0");
        String dvj = new String("OperatorA_trip_12345");
        DataFrameRefStructure dfr = new DataFrameRefStructure();
        dfr.setValue("2014-05-14");
        FramedVehicleJourneyRefStructure fvj = new FramedVehicleJourneyRefStructure();
        fvj.setDatedVehicleJourneyRef(dvj);
        fvj.setDataFrameRef(dfr);
        JourneyPatternRefStructure jprs = new JourneyPatternRefStructure();
        jprs.setValue("Shape_5678");
        NaturalLanguageStringStructure pln = new NaturalLanguageStringStructure();
        pln.setValue("Line1");
        OperatorRefStructure opref = new OperatorRefStructure();
        opref.setValue("OperatorA");
        JourneyPlaceRefStructure originref = new JourneyPlaceRefStructure();
        originref.setValue("StopA");
        JourneyPlaceRefStructure destref = new JourneyPlaceRefStructure();
        destref.setValue("StopZ");
        NaturalLanguageStringStructure destname = new NaturalLanguageStringStructure();
        destname.setValue("Stop Z");
        NaturalLanguageStringStructure approaching = new NaturalLanguageStringStructure();
        approaching.setValue("Approaching");
        NaturalLanguageStringStructure oneStopAway = new NaturalLanguageStringStructure();
        oneStopAway.setValue("1 Stop Away");
        mvj.setLocationRecordedAtTime(nowTime);
        msv.setRecordedAtTime(nowTime);
        mc.setNumberOfStopsAway(BigInteger.ZERO);
        mc.setExpectedArrivalTime(arrtime);
        mc.setArrivalProximityText(approaching);
        mc.setDistanceFromStop(BigInteger.valueOf(200L));
        mvj.getPublishedLineName().add(pln);
        mvj.getDestinationName().add(destname);
        mvj.setMonitored(true);
        if (detailLevel == "basic" || detailLevel == "normal" || detailLevel == "calls") {
            mc.setStopPointRef(stoprefA);
            mvj.setFramedVehicleJourneyRef(fvj);
            mvj.setDirectionRef(dr);
            mvj.setOperatorRef(opref);
            mvj.setLineRef(line);
            mvj.setProgressRate(ProgressRateEnumeration.NORMAL_PROGRESS);
        }
        if (detailLevel == "normal" || detailLevel == "calls") {
            mc.getStopPointName().add(stopnameA);
            mvj.setOriginRef(originref);
            mvj.setJourneyPatternRef(jprs);
        }
        if (detailLevel == "calls") {
            OnwardCallsStructure ocs = new OnwardCallsStructure();
            OnwardCallStructure oc = new OnwardCallStructure();
            oc.setAimedArrivalTime(arrtime2);
            oc.setDistanceFromStop(BigInteger.valueOf(400L));
            oc.setStopPointRef(stoprefB);
            oc.getStopPointName().add(stopnameB);
            oc.setVisitNumber(BigInteger.valueOf(1L));
            oc.setArrivalProximityText(oneStopAway);
            oc.setNumberOfStopsAway(BigInteger.ONE);
            ocs.getOnwardCall().add(oc);
            mvj.setOnwardCalls(ocs);
        }
        mvj.setMonitoredCall(mc);
        msv.setMonitoredVehicleJourney(mvj);
        smds.getMonitoredStopVisit().add(msv);
        smds.setResponseTimestamp(nowTime);
        sd.setResponseTimestamp(nowTime);
        sd.getStopMonitoringDelivery().add(smds);
        return sd;
    }
}

