/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geotools.filter.FilterNameTypeMapping;
import org.geotools.filter.Filters;
import org.opengis.filter.And;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class FilterCapabilities {
    public static final long NO_OP = 0L;
    public static final long NONE = 0x40000000L;
    public static final long ALL = Integer.MIN_VALUE;
    public static final long SPATIAL_BBOX = 1L;
    public static final long SPATIAL_EQUALS = 2L;
    public static final long SPATIAL_DISJOINT = 4L;
    public static final long SPATIAL_INTERSECT = 8L;
    public static final long SPATIAL_TOUCHES = 16L;
    public static final long SPATIAL_CROSSES = 32L;
    public static final long SPATIAL_WITHIN = 64L;
    public static final long SPATIAL_CONTAINS = 128L;
    public static final long SPATIAL_OVERLAPS = 256L;
    public static final long SPATIAL_BEYOND = 512L;
    public static final long SPATIAL_DWITHIN = 1024L;
    public static final long LIKE = 2048L;
    public static final long BETWEEN = 4096L;
    public static final long NULL_CHECK = 8192L;
    public static final long SIMPLE_ARITHMETIC = 16384L;
    public static final long FUNCTIONS = 32768L;
    public static final long COMPARE_EQUALS = 65536L;
    public static final long COMPARE_GREATER_THAN = 131072L;
    public static final long COMPARE_GREATER_THAN_EQUAL = 262144L;
    public static final long COMPARE_LESS_THAN = 524288L;
    public static final long COMPARE_LESS_THAN_EQUAL = 0x100000L;
    public static final long COMPARE_NOT_EQUALS = 0x200000L;
    public static final long FID = 0x400000L;
    public static final long LOGIC_AND = 0x800000L;
    public static final long LOGIC_NOT = 0x1000000L;
    public static final long LOGIC_OR = 0x2000000L;
    public static final long LOGICAL = 0x3800000L;
    public static final long SIMPLE_COMPARISONS = 0x3F0000L;
    public static final FilterCapabilities SIMPLE_COMPARISONS_OPENGIS;
    public static final FilterCapabilities LOGICAL_OPENGIS;
    static final Map intTypeToOpenGisTypeMap;
    private long ops = 0L;
    private Set functions = new HashSet();

    public FilterCapabilities(long filterCapabilitiesType) {
        this.addType(filterCapabilitiesType);
    }

    public FilterCapabilities() {
        this(0L);
    }

    public FilterCapabilities(Class type) {
        this.addType(type);
    }

    public void addType(long type) {
        if ((this.ops & type) != 0L) {
            return;
        }
        this.ops |= type;
        for (Map.Entry entry : intTypeToOpenGisTypeMap.entrySet()) {
            Object filter;
            long key = (Long)entry.getKey();
            if ((key & type) == 0L || (filter = entry.getValue()) == null) continue;
            if (filter instanceof Class[]) {
                Class[] filters = (Class[])filter;
                for (int i = 0; i < filters.length; ++i) {
                    this.addType(filters[i], false);
                }
                continue;
            }
            this.addType((Class)filter, false);
        }
    }

    public void addType(Class type) {
        if (Filter.class.isAssignableFrom(type) || Expression.class.isAssignableFrom(type)) {
            this.addType(32768L);
            this.functions.add(type);
        }
    }

    public void addType(Class type, boolean addFunctionType) {
        if (Filter.class.isAssignableFrom(type) || Expression.class.isAssignableFrom(type)) {
            if (addFunctionType) {
                this.addType(32768L);
            }
            this.functions.add(type);
        }
    }

    public void addAll(FilterCapabilities capabilities) {
        this.addType(capabilities.ops);
        this.functions.addAll(capabilities.functions);
    }

    public void addType(short type) {
        this.addAll(this.convertFilterTypeToMask(type));
    }

    public FilterCapabilities convertFilterTypeToMask(short type) {
        if (type == -12345) {
            return FilterNameTypeMapping.NO_OP_CAPS;
        }
        if (type == 12345) {
            return FilterNameTypeMapping.ALL_CAPS;
        }
        Object object = FilterNameTypeMapping.filterTypeToFilterCapabilitiesMap.get(new Short(type));
        return (FilterCapabilities)object;
    }

    public boolean supports(Filter filter) {
        Iterator ifunc = this.functions.iterator();
        while (ifunc.hasNext()) {
            if (!((Class)ifunc.next()).isAssignableFrom(filter.getClass())) continue;
            return true;
        }
        if (this.functions.contains(filter.getClass())) {
            return true;
        }
        short filterType = Filters.getFilterType(filter);
        if (filterType == 0) {
            return false;
        }
        return this.supports(filterType);
    }

    public boolean fullySupports(Filter filter) {
        boolean supports = true;
        if (filter == null) {
            throw new IllegalArgumentException("Null filters can not be unpacked, did you mean Filter.INCLUDE?");
        }
        short filterType = Filters.getFilterType(filter);
        if (filter instanceof BinaryLogicOperator) {
            BinaryLogicOperator lf = (BinaryLogicOperator)filter;
            for (Filter testFilter : lf.getChildren()) {
                if (this.fullySupports(testFilter)) continue;
                supports = false;
                break;
            }
        } else if (filter instanceof Not) {
            Not lf = (Not)filter;
            if (!this.fullySupports(lf.getFilter())) {
                supports = false;
            }
        } else {
            supports = this.supports(filter);
        }
        return supports;
    }

    public boolean supports(short type) {
        return this.supports(this.convertFilterTypeToMask(type));
    }

    public boolean supports(long type) {
        return (this.ops & type) == type;
    }

    public boolean supports(FilterCapabilities type) {
        return (this.ops & type.ops) == type.ops && this.functions.containsAll(type.functions);
    }

    public boolean supports(Class type) {
        return this.functions.contains(type);
    }

    public long getScalarOps() {
        return this.ops & 0x3FFF800L;
    }

    public long getSpatialOps() {
        return this.ops & 0x7FFL;
    }

    public static FilterCapabilities findOperation(String name) {
        return FilterNameTypeMapping.findOperation(name);
    }

    public static FilterCapabilities findFunction(String name) {
        return FilterNameTypeMapping.findFunction(name);
    }

    static {
        intTypeToOpenGisTypeMap = new HashMap();
        SIMPLE_COMPARISONS_OPENGIS = new FilterCapabilities();
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsEqualTo.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsGreaterThan.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsGreaterThanOrEqualTo.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsLessThanOrEqualTo.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsLessThan.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsNotEqualTo.class);
        LOGICAL_OPENGIS = new FilterCapabilities();
        LOGICAL_OPENGIS.addType(And.class);
        LOGICAL_OPENGIS.addType(Not.class);
        LOGICAL_OPENGIS.addType(Or.class);
        intTypeToOpenGisTypeMap.put(new Long(1L), BBOX.class);
        intTypeToOpenGisTypeMap.put(new Long(2L), Equals.class);
        intTypeToOpenGisTypeMap.put(new Long(4L), Disjoint.class);
        intTypeToOpenGisTypeMap.put(new Long(8L), Intersects.class);
        intTypeToOpenGisTypeMap.put(new Long(16L), Touches.class);
        intTypeToOpenGisTypeMap.put(new Long(32L), Crosses.class);
        intTypeToOpenGisTypeMap.put(new Long(64L), Within.class);
        intTypeToOpenGisTypeMap.put(new Long(128L), Contains.class);
        intTypeToOpenGisTypeMap.put(new Long(256L), Overlaps.class);
        intTypeToOpenGisTypeMap.put(new Long(512L), Beyond.class);
        intTypeToOpenGisTypeMap.put(new Long(1024L), DWithin.class);
        intTypeToOpenGisTypeMap.put(new Long(16384L), new Class[]{Add.class, Subtract.class, Multiply.class, Divide.class});
        intTypeToOpenGisTypeMap.put(new Long(32768L), Function.class);
        intTypeToOpenGisTypeMap.put(new Long(65536L), PropertyIsEqualTo.class);
        intTypeToOpenGisTypeMap.put(new Long(0x200000L), PropertyIsNotEqualTo.class);
        intTypeToOpenGisTypeMap.put(new Long(131072L), PropertyIsGreaterThan.class);
        intTypeToOpenGisTypeMap.put(new Long(262144L), PropertyIsGreaterThanOrEqualTo.class);
        intTypeToOpenGisTypeMap.put(new Long(524288L), PropertyIsLessThan.class);
        intTypeToOpenGisTypeMap.put(new Long(0x100000L), PropertyIsLessThanOrEqualTo.class);
        intTypeToOpenGisTypeMap.put(new Long(8192L), PropertyIsNull.class);
        intTypeToOpenGisTypeMap.put(new Long(2048L), PropertyIsLike.class);
        intTypeToOpenGisTypeMap.put(new Long(4096L), PropertyIsBetween.class);
        intTypeToOpenGisTypeMap.put(new Long(0x800000L), And.class);
        intTypeToOpenGisTypeMap.put(new Long(0x2000000L), Or.class);
        intTypeToOpenGisTypeMap.put(new Long(0x1000000L), Not.class);
    }
}

