/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

public class SpatialIndexFeatureCollection
implements SimpleFeatureCollection {
    static Logger LOGGER = Logging.getLogger(SpatialIndexFeatureCollection.class);
    protected STRtree index = new STRtree();
    protected SimpleFeatureType schema;
    protected List<CollectionListener> listeners = null;

    public SpatialIndexFeatureCollection() {
    }

    public SpatialIndexFeatureCollection(SimpleFeatureType schema) {
        this.schema = schema;
    }

    public SpatialIndexFeatureCollection(SimpleFeatureCollection copy) throws IOException {
        this((SimpleFeatureType)copy.getSchema());
        this.addAll(copy);
    }

    public synchronized void addListener(CollectionListener listener) throws NullPointerException {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(CollectionListener listener) throws NullPointerException {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void fire(SimpleFeature[] features, int eventType) {
        CollectionListener[] notify;
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        CollectionEvent event = new CollectionEvent(this, features, eventType);
        for (CollectionListener listener : notify = this.listeners.toArray(new CollectionListener[this.listeners.size()])) {
            try {
                listener.collectionChanged(event);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Problem encountered during notification of " + event, t);
            }
        }
    }

    @Override
    public SimpleFeatureIterator features() {
        Envelope everything = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        List list = this.index.query(everything);
        final Iterator iterator = list.iterator();
        return new SimpleFeatureIterator(){

            @Override
            public SimpleFeature next() throws NoSuchElementException {
                return (SimpleFeature)iterator.next();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        SpatialIndexFeatureCollection ret = new SpatialIndexFeatureCollection(this.schema);
        Envelope env = new Envelope();
        env = (Envelope)filter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, (Object)env);
        if (LOGGER.isLoggable(Level.FINEST) && Double.isInfinite(env.getWidth())) {
            LOGGER.fine("Found no spatial element in " + filter);
            LOGGER.fine("Just going to iterate");
        }
        for (SimpleFeature sample : this.index.query(env)) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Looking at " + sample);
            }
            if (!filter.evaluate((Object)sample)) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("accepting " + sample);
            }
            ret.add(sample);
        }
        return ret;
    }

    @Override
    public void accepts(final FeatureVisitor visitor, ProgressListener listener) throws IOException {
        Envelope everything = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        final ProgressListener progress = listener != null ? listener : new NullProgressListener();
        progress.started();
        final float size = this.size();
        final IOException[] problem = new IOException[1];
        this.index.query(everything, new ItemVisitor(){
            float count = 0.0f;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitItem(Object item) {
                SimpleFeature feature = null;
                try {
                    feature = (SimpleFeature)item;
                    visitor.visit((Feature)feature);
                }
                catch (Throwable t) {
                    progress.exceptionOccurred(t);
                    String fid = feature == null ? "feature" : feature.getIdentifier().toString();
                    problem[0] = new IOException("Problem visiting " + fid + ":" + t, t);
                }
                finally {
                    progress.progress(this.count / size);
                }
            }
        });
        if (problem[0] != null) {
            throw problem[0];
        }
        progress.complete();
    }

    public boolean add(SimpleFeature feature) {
        ReferencedEnvelope bounds = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)feature.getBounds());
        this.index.insert((Envelope)bounds, (Object)feature);
        return false;
    }

    public boolean addAll(Collection<? extends SimpleFeature> collection) {
        for (SimpleFeature simpleFeature : collection) {
            try {
                ReferencedEnvelope bounds = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)simpleFeature.getBounds());
                this.index.insert((Envelope)bounds, (Object)simpleFeature);
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(FeatureCollection<? extends SimpleFeatureType, ? extends SimpleFeature> collection) {
        try (FeatureIterator<? extends SimpleFeature> iter = collection.features();){
            while (iter.hasNext()) {
                try {
                    SimpleFeature feature = iter.next();
                    ReferencedEnvelope bounds = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)feature.getBounds());
                    this.index.insert((Envelope)bounds, (Object)feature);
                }
                catch (Throwable throwable) {}
            }
        }
        return false;
    }

    public synchronized void clear() {
        this.index = null;
        this.index = new STRtree();
        this.listeners.clear();
        this.listeners = null;
    }

    public void close(FeatureIterator<SimpleFeature> close) {
    }

    public void close(Iterator<SimpleFeature> close) {
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)obj;
            ReferencedEnvelope bounds = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)feature.getBounds());
            Iterator iter = (Iterator)((Object)this.index.query((Envelope)bounds));
            while (iter.hasNext()) {
                SimpleFeature sample = (SimpleFeature)iter.next();
                if (sample != feature) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        boolean containsAll = true;
        for (Object obj : collection) {
            boolean contains = this.contains(obj);
            if (contains) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        CoordinateReferenceSystem crs = this.schema.getCoordinateReferenceSystem();
        Envelope bounds = (Envelope)this.index.getRoot().getBounds();
        return new ReferencedEnvelope(bounds, crs);
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    @Override
    public boolean isEmpty() {
        return this.index.itemsTree().isEmpty();
    }

    public Iterator<SimpleFeature> iterator() {
        Envelope everything = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        List list = this.index.query(everything);
        return list.iterator();
    }

    public void purge() {
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot remove items from STRtree");
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot remove items from STRtree");
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot remove items from STRtree");
    }

    @Override
    public int size() {
        return this.index.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <O> O[] toArray(O[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        Iterator<SimpleFeature> it = this.iterator();
        try {
            O[] result = array;
            for (int i = 0; i < size; ++i) {
                result[i] = it.next();
            }
            if (array.length > size) {
                array[size] = null;
            }
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.close(it);
        }
    }
}

