/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiLibrary {
    private static int DEFAULT_READ_TIMEOUT = 60000;
    private static int DEFAULT_CONNECTION_TIMEOUT = 60000;
    private String _protocol = "http";
    private String _host = null;
    private String _apiPrefix = "/api/";
    private int _port = 80;
    private int readTimeout = DEFAULT_READ_TIMEOUT;
    private int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private static Logger log = LoggerFactory.getLogger(RestApiLibrary.class);

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public RestApiLibrary(String protocol, String host, Integer port, String apiPrefix) {
        this._host = host;
        this._apiPrefix = apiPrefix;
        if (StringUtils.isNotBlank((String)protocol)) {
            this._protocol = protocol;
        }
        if (port != null) {
            this._port = port;
        }
    }

    public RestApiLibrary(String host, Integer port, String apiPrefix) {
        this("http", host, port, apiPrefix);
    }

    public URL buildUrl(String baseObject, String ... params) throws MalformedURLException {
        Object url = this._apiPrefix;
        url = (String)url + baseObject;
        if (params.length > 0) {
            url = (String)url + "/";
            for (int i = 0; i < params.length; ++i) {
                String param = params[i];
                url = (String)url + param;
                if (i >= params.length - 1) continue;
                url = (String)url + "/";
            }
        }
        return new URL(this._protocol, this._host, this._port, (String)url);
    }

    public String getContentsOfUrlAsString(URL requestUrl) throws IOException {
        BufferedReader br = null;
        InputStream inStream = null;
        URLConnection conn = null;
        try {
            int cp;
            conn = requestUrl.openConnection();
            conn.setConnectTimeout(this.connectionTimeout);
            conn.setReadTimeout(this.readTimeout);
            inStream = conn.getInputStream();
            br = new BufferedReader(new InputStreamReader(inStream));
            StringBuilder output = new StringBuilder();
            while ((cp = br.read()) != -1) {
                output.append((char)cp);
            }
            String string = output.toString();
            return string;
        }
        catch (IOException ioe) {
            String url = requestUrl != null ? requestUrl.toExternalForm() : "url unavailable";
            log.error("Error getting contents of url: " + url + ", " + ioe.toString());
            throw ioe;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ioe2) {
                log.error("Error closing connection");
            }
        }
    }

    public ArrayList<JsonObject> getJsonObjectsForString(String string) {
        JsonParser parser = new JsonParser();
        JsonObject response = null;
        response = (JsonObject)parser.parse(string);
        ArrayList<JsonObject> output = new ArrayList<JsonObject>();
        for (Map.Entry item : response.entrySet()) {
            String type = (String)item.getKey();
            JsonElement responseItemWrapper = (JsonElement)item.getValue();
            if (type.equals("status")) continue;
            try {
                for (JsonElement arrayElement : responseItemWrapper.getAsJsonArray()) {
                    output.add(arrayElement.getAsJsonObject());
                }
            }
            catch (Exception e) {
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setContents(URL requestUrl, String value) throws Exception {
        HttpURLConnection conn = this.getHttpURLConnection(requestUrl);
        int responseCode = 0;
        try {
            String content = "{\"config\":{\"value\":\"" + value + "\"}}";
            conn.connect();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(conn.getOutputStream());
            outputStreamWriter.write(content);
            outputStreamWriter.close();
            responseCode = conn.getResponseCode();
        }
        catch (Exception e) {
            log.error("Error writing value on TDM");
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return responseCode == 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String log(String baseIdentifier, String component, Integer priority, String message) {
        String url = this._apiPrefix + baseIdentifier;
        HttpURLConnection conn = null;
        String response = null;
        URL requestUrl = null;
        try {
            requestUrl = new URL("http", this._host, this._port, url);
            conn = this.getHttpURLConnection(requestUrl);
            conn.connect();
            String content = this.buildMessage(component, priority, message);
            log.info("Writing content : {} to http connection", (Object)content);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(conn.getOutputStream());
            outputStreamWriter.write(content);
            outputStreamWriter.close();
            response = conn.getResponseMessage();
        }
        catch (MalformedURLException e) {
            log.error("Error building url : {}", (Object)requestUrl.toString());
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error("Error opening http connection to url : {}", (Object)requestUrl.toString());
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response;
    }

    private String buildMessage(String component, Integer priority, String message) {
        StringBuilder messageBuilder = new StringBuilder("{\"component\":\"");
        messageBuilder.append(component);
        messageBuilder.append("\",\"priority\":\"");
        messageBuilder.append(priority);
        messageBuilder.append("\",\"message\":\"");
        messageBuilder.append(message);
        messageBuilder.append("\"}");
        return messageBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection getHttpURLConnection(URL requestUrl) {
        HttpURLConnection conn = null;
        try {
            conn = requestUrl.getProtocol().toLowerCase().equals("https") ? (HttpsURLConnection)requestUrl.openConnection() : (HttpURLConnection)requestUrl.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setUseCaches(false);
            conn.setDoOutput(true);
        }
        catch (IOException e) {
            log.error("Error opening Http Connection for url : {}", (Object)requestUrl.toString());
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return conn;
    }
}

