/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.realtime;

import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.ScheduleDeviationSamples;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationCacheElement;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationCacheElements;

public class VehicleLocationCacheEntry {
    private final BlockInstance _blockInstance;
    private VehicleLocationCacheElements _elements;
    private boolean _closed = false;

    public VehicleLocationCacheEntry(BlockInstance blockInstance) {
        this._blockInstance = blockInstance;
        this._elements = new VehicleLocationCacheElements(blockInstance);
    }

    public BlockInstance getBlockInstance() {
        return this._blockInstance;
    }

    public synchronized boolean isClosed() {
        return this._closed;
    }

    public synchronized boolean addElement(VehicleLocationRecord record, ScheduledBlockLocation scheduledBlockLocation, ScheduleDeviationSamples samples) {
        if (this._closed) {
            return false;
        }
        VehicleLocationCacheElement element = new VehicleLocationCacheElement(record, scheduledBlockLocation, samples);
        this._elements = this._elements.extend(element);
        return true;
    }

    public synchronized boolean isClosedBecauseBlockInstanceChanged(BlockInstance blockInstance) {
        if (this._closed) {
            return true;
        }
        if (!this._blockInstance.equals(blockInstance)) {
            this._closed = true;
            return true;
        }
        return false;
    }

    public synchronized boolean closeIfStale(long time) {
        if (this._closed) {
            return true;
        }
        this._elements = this._elements.pruneOlderThanTime(time);
        if (this._elements.isEmpty()) {
            this._closed = true;
            return true;
        }
        return false;
    }

    public synchronized VehicleLocationCacheElements getElements() {
        return this._elements;
    }
}

