/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.realtime;

import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;

public class TripLocation {
    private TripEntry trip;
    private long serviceDate;
    private boolean inService;
    private CoordinatePoint location;
    private double distanceAlongRoute = Double.NaN;
    private StopTimeEntry closestStop;
    private int closestStopTimeOffset;
    private boolean predicted;
    private long lastUpdateTime;
    private CoordinatePoint lastKnownLocation;
    private double scheduleDeviation = Double.NaN;
    private AgencyAndId vehicleId;

    public TripEntry getTrip() {
        return this.trip;
    }

    public void setTrip(TripEntry trip) {
        this.trip = trip;
    }

    public long getServiceDate() {
        return this.serviceDate;
    }

    public void setServiceDate(long serviceDate) {
        this.serviceDate = serviceDate;
    }

    public boolean isInService() {
        return this.inService;
    }

    public void setInService(boolean inService) {
        this.inService = inService;
    }

    public CoordinatePoint getLocation() {
        return this.location;
    }

    public void setLocation(CoordinatePoint location) {
        this.location = location;
    }

    public boolean hasDistanceAlongTrip() {
        return !Double.isNaN(this.distanceAlongRoute);
    }

    public double getDistanceAlongTrip() {
        return this.distanceAlongRoute;
    }

    public void setDistanceAlongRoute(double distanceAlongRoute) {
        this.distanceAlongRoute = distanceAlongRoute;
    }

    public StopTimeEntry getClosestStop() {
        return this.closestStop;
    }

    public void setClosestStop(StopTimeEntry closestStop) {
        this.closestStop = closestStop;
    }

    public int getClosestStopTimeOffset() {
        return this.closestStopTimeOffset;
    }

    public void setClosestStopTimeOffset(int closestStopTimeOffset) {
        this.closestStopTimeOffset = closestStopTimeOffset;
    }

    public boolean isPredicted() {
        return this.predicted;
    }

    public void setPredicted(boolean predicted) {
        this.predicted = predicted;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long time) {
        this.lastUpdateTime = time;
    }

    public CoordinatePoint getLastKnownLocation() {
        return this.lastKnownLocation;
    }

    public void setLastKnownLocation(CoordinatePoint lastKnownLocation) {
        this.lastKnownLocation = lastKnownLocation;
    }

    public boolean hasScheduleDeviation() {
        return !Double.isNaN(this.scheduleDeviation);
    }

    public double getScheduleDeviation() {
        return this.scheduleDeviation;
    }

    public void setScheduleDeviation(double scheduleDeviation) {
        this.scheduleDeviation = scheduleDeviation;
    }

    public AgencyAndId getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(AgencyAndId vehicleId) {
        this.vehicleId = vehicleId;
    }
}

