/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.realtime;

import java.util.List;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.EVehiclePhase;
import org.onebusaway.realtime.api.EVehicleType;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripInstance;
import org.onebusaway.transit_data_federation.services.realtime.ScheduleDeviationSamples;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;

public class BlockLocation {
    private long time;
    private BlockInstance blockInstance;
    private int blockStartTime;
    private BlockTripEntry activeTrip;
    private boolean inService;
    private double scheduledDistanceAlongBlock = Double.NaN;
    private double distanceAlongBlock = Double.NaN;
    private int effectiveScheduleTime;
    private CoordinatePoint location;
    private double orientation = Double.NaN;
    private BlockStopTimeEntry closestStop;
    private int closestStopTimeOffset;
    private BlockStopTimeEntry nextStop;
    private int nextStopTimeOffset;
    private BlockStopTimeEntry previousStop;
    private int previousStopTimeOffset;
    private EVehiclePhase phase;
    private EVehicleType vehicleType;
    private String status;
    private boolean predicted;
    private long lastUpdateTime;
    private long lastLocationUpdateTime;
    private double lastKnownDistanceAlongBlock = Double.NaN;
    private CoordinatePoint lastKnownLocation;
    private double lastKnownOrientation = Double.NaN;
    private double scheduleDeviation = Double.NaN;
    private ScheduleDeviationSamples scheduleDeviations = null;
    private AgencyAndId vehicleId;
    private List<TimepointPredictionRecord> timepointPredictions;
    private List<String> vehicleFeatures;

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public BlockInstance getBlockInstance() {
        return this.blockInstance;
    }

    public void setBlockInstance(BlockInstance instance) {
        this.blockInstance = instance;
    }

    public int getBlockStartTime() {
        return this.blockStartTime;
    }

    public void setBlockStartTime(int blockStartTime) {
        this.blockStartTime = blockStartTime;
    }

    public BlockTripEntry getActiveTrip() {
        return this.activeTrip;
    }

    public void setActiveTrip(BlockTripEntry activeTrip) {
        this.activeTrip = activeTrip;
    }

    public BlockTripInstance getActiveTripInstance() {
        if (this.activeTrip == null) {
            return null;
        }
        return new BlockTripInstance(this.activeTrip, this.blockInstance.getState());
    }

    public boolean isInService() {
        return this.inService;
    }

    public void setInService(boolean inService) {
        this.inService = inService;
    }

    public boolean isScheduledDistanceAlongBlockSet() {
        return !Double.isNaN(this.scheduledDistanceAlongBlock);
    }

    public double getScheduledDistanceAlongBlock() {
        return this.scheduledDistanceAlongBlock;
    }

    public void setScheduledDistanceAlongBlock(double scheduledDistanceAlongBlock) {
        this.scheduledDistanceAlongBlock = scheduledDistanceAlongBlock;
    }

    public int getEffectiveScheduleTime() {
        return this.effectiveScheduleTime;
    }

    public void setEffectiveScheduleTime(int effectiveScheduleTime) {
        this.effectiveScheduleTime = effectiveScheduleTime;
    }

    public boolean isDistanceAlongBlockSet() {
        return !Double.isNaN(this.distanceAlongBlock);
    }

    public double getDistanceAlongBlock() {
        return this.distanceAlongBlock;
    }

    public void setDistanceAlongBlock(double distanceAlongBlock) {
        this.distanceAlongBlock = distanceAlongBlock;
    }

    public CoordinatePoint getLocation() {
        return this.location;
    }

    public void setLocation(CoordinatePoint location) {
        this.location = location;
    }

    public boolean isOrientationSet() {
        return !Double.isNaN(this.orientation);
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void setOrientation(double orientation) {
        this.orientation = orientation;
    }

    public BlockStopTimeEntry getClosestStop() {
        return this.closestStop;
    }

    public void setClosestStop(BlockStopTimeEntry closestStop) {
        this.closestStop = closestStop;
    }

    public int getClosestStopTimeOffset() {
        return this.closestStopTimeOffset;
    }

    public void setClosestStopTimeOffset(int closestStopTimeOffset) {
        this.closestStopTimeOffset = closestStopTimeOffset;
    }

    public BlockStopTimeEntry getNextStop() {
        return this.nextStop;
    }

    public void setNextStop(BlockStopTimeEntry nextStop) {
        this.nextStop = nextStop;
    }

    public int getNextStopTimeOffset() {
        return this.nextStopTimeOffset;
    }

    public void setNextStopTimeOffset(int nextStopTimeOffset) {
        this.nextStopTimeOffset = nextStopTimeOffset;
    }

    public BlockStopTimeEntry getPreviousStop() {
        return this.previousStop;
    }

    public void setPreviousStop(BlockStopTimeEntry previousStop) {
        this.previousStop = previousStop;
    }

    public int getPreviousStopTimeOffset() {
        return this.previousStopTimeOffset;
    }

    public void setPreviousStopTimeOffset(int previousStopTimeOffset) {
        this.previousStopTimeOffset = previousStopTimeOffset;
    }

    public EVehiclePhase getPhase() {
        return this.phase;
    }

    public void setPhase(EVehiclePhase phase) {
        this.phase = phase;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public EVehicleType getVehicleType() {
        return this.vehicleType;
    }

    public void setVehicleType(EVehicleType vehicleType) {
        this.vehicleType = vehicleType;
    }

    public boolean isPredicted() {
        return this.predicted;
    }

    public void setPredicted(boolean predicted) {
        this.predicted = predicted;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public long getLastLocationUpdateTime() {
        return this.lastLocationUpdateTime;
    }

    public void setLastLocationUpdateTime(long lastLocationUpdateTime) {
        this.lastLocationUpdateTime = lastLocationUpdateTime;
    }

    public boolean isLastKnownDistanceAlongBlockSet() {
        return !Double.isNaN(this.lastKnownDistanceAlongBlock);
    }

    public double getLastKnownDistanceAlongBlock() {
        return this.lastKnownDistanceAlongBlock;
    }

    public void setLastKnownDistanceAlongBlock(double lastKnownDistanceAlongBlock) {
        this.lastKnownDistanceAlongBlock = lastKnownDistanceAlongBlock;
    }

    public CoordinatePoint getLastKnownLocation() {
        return this.lastKnownLocation;
    }

    public void setLastKnownLocation(CoordinatePoint lastKnownLocation) {
        this.lastKnownLocation = lastKnownLocation;
    }

    public boolean isLastKnownOrientationSet() {
        return !Double.isNaN(this.lastKnownOrientation);
    }

    public double getLastKnownOrientation() {
        return this.lastKnownOrientation;
    }

    public void setLastKnownOrientation(double lastKnownOrientation) {
        this.lastKnownOrientation = lastKnownOrientation;
    }

    public boolean isScheduleDeviationSet() {
        return !Double.isNaN(this.scheduleDeviation);
    }

    public double getScheduleDeviation() {
        return this.scheduleDeviation;
    }

    public void setScheduleDeviation(double scheduleDeviation) {
        this.scheduleDeviation = scheduleDeviation;
    }

    public boolean areScheduleDeviationsSet() {
        return this.scheduleDeviations != null && !this.scheduleDeviations.isEmpty();
    }

    public ScheduleDeviationSamples getScheduleDeviations() {
        return this.scheduleDeviations;
    }

    public void setScheduleDeviations(ScheduleDeviationSamples scheduleDeviations) {
        this.scheduleDeviations = scheduleDeviations;
    }

    public AgencyAndId getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(AgencyAndId vehicleId) {
        this.vehicleId = vehicleId;
    }

    public List<TimepointPredictionRecord> getTimepointPredictions() {
        return this.timepointPredictions;
    }

    public void setTimepointPredictions(List<TimepointPredictionRecord> timepointPredictions) {
        this.timepointPredictions = timepointPredictions;
    }

    public void setVehicleFeatures(List<String> vehicleFeatures) {
        this.vehicleFeatures = vehicleFeatures;
    }

    public List<String> getVehicleFeatures() {
        return this.vehicleFeatures;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BlockLocation(");
        if (this.blockInstance != null && this.blockInstance.getBlock() != null) {
            b.append("block=").append(this.blockInstance.getBlock().getBlock().getId()).append(",");
        }
        if (this.phase != null) {
            b.append("phase=").append(this.phase).append(",");
        }
        if (this.status != null) {
            b.append("status=").append(this.status).append(",");
        }
        if (this.isScheduleDeviationSet()) {
            b.append("scheduleDeviation=").append(this.scheduleDeviation).append(",");
        }
        if (this.predicted) {
            b.append("predicted=true,");
        }
        if (this.isDistanceAlongBlockSet()) {
            b.append("distanceAlongBlock=").append(this.distanceAlongBlock).append(",");
        }
        if (this.vehicleId != null) {
            b.append("vehicleId=").append(this.vehicleId).append(",");
        }
        b.append(")");
        return b.toString();
    }
}

