/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.realtime;

import java.text.DateFormat;
import java.util.Date;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.transit_data.model.TimeIntervalBean;
import org.onebusaway.transit_data_federation.impl.blocks.BlockSequence;
import org.onebusaway.transit_data_federation.model.StopTimeInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripInstance;
import org.onebusaway.transit_data_federation.services.realtime.ArrivalAndDepartureTime;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;

public class ArrivalAndDepartureInstance {
    private static final long serialVersionUID = 3L;
    private static DateFormat _format = DateFormat.getTimeInstance(3);
    private final StopTimeInstance stopTimeInstance;
    private long scheduledArrivalTime;
    private long scheduledDepartureTime;
    private BlockLocation blockLocation;
    private BlockSequence blockSequence;
    private long predictedArrivalTime;
    private TimeIntervalBean predictedArrivalInterval;
    private long predictedDepartureTime;
    private OccupancyStatus historicalOccupancy;
    private OccupancyStatus predictedOccupancy;
    private TimeIntervalBean predictedDepartureInterval;
    private String scheduledTrack;
    private String actualTrack;
    private String status;

    public ArrivalAndDepartureInstance(StopTimeInstance stopTimeInstance, ArrivalAndDepartureTime scheduledTime) {
        if (stopTimeInstance == null) {
            throw new IllegalArgumentException("stopTimeInstance is null");
        }
        this.stopTimeInstance = stopTimeInstance;
        this.scheduledArrivalTime = scheduledTime.getArrivalTime();
        this.scheduledDepartureTime = scheduledTime.getDepartureTime();
        this.historicalOccupancy = stopTimeInstance.getStopTime().getStopTime().getHistoricalOccupancy();
    }

    public ArrivalAndDepartureInstance(StopTimeInstance stopTimeInstance) {
        this(stopTimeInstance, ArrivalAndDepartureTime.getScheduledTime(stopTimeInstance));
    }

    public StopTimeInstance getStopTimeInstance() {
        return this.stopTimeInstance;
    }

    public BlockInstance getBlockInstance() {
        return this.stopTimeInstance.getBlockInstance();
    }

    public BlockStopTimeEntry getBlockStopTime() {
        return this.stopTimeInstance.getStopTime();
    }

    public BlockLocation getBlockLocation() {
        return this.blockLocation;
    }

    public void setBlockLocation(BlockLocation blockLocation) {
        this.blockLocation = blockLocation;
    }

    public BlockSequence getBlockSequence() {
        return this.blockSequence;
    }

    public void setBlockSequence(BlockSequence blockSequence) {
        this.blockSequence = blockSequence;
    }

    public void setScheduledArrivalTime(long scheduledArrivalTime) {
        this.scheduledArrivalTime = scheduledArrivalTime;
    }

    public long getScheduledArrivalTime() {
        return this.scheduledArrivalTime;
    }

    public void setScheduledDepartureTime(long scheduledDepartureTime) {
        this.scheduledDepartureTime = scheduledDepartureTime;
    }

    public long getScheduledDepartureTime() {
        return this.scheduledDepartureTime;
    }

    public boolean isPredictedArrivalTimeSet() {
        return this.predictedArrivalTime != 0L;
    }

    public long getPredictedArrivalTime() {
        return this.predictedArrivalTime;
    }

    public void setPredictedArrivalTime(long predictedArrivalTime) {
        this.predictedArrivalTime = predictedArrivalTime;
    }

    public TimeIntervalBean getPredictedArrivalInterval() {
        return this.predictedArrivalInterval;
    }

    public void setPredictedArrivalInterval(TimeIntervalBean predictedArrivalInterval) {
        this.predictedArrivalInterval = predictedArrivalInterval;
    }

    public boolean isPredictedDepartureTimeSet() {
        return this.predictedDepartureTime != 0L;
    }

    public long getPredictedDepartureTime() {
        return this.predictedDepartureTime;
    }

    public void setPredictedDepartureTime(long predictedDepartureTime) {
        this.predictedDepartureTime = predictedDepartureTime;
    }

    public OccupancyStatus getHistoricalOccupancy() {
        return this.historicalOccupancy;
    }

    public void setHistoricalOccupancy(OccupancyStatus historicalOccupancy) {
        this.historicalOccupancy = historicalOccupancy;
    }

    public OccupancyStatus getPredictedOccupancy() {
        return this.predictedOccupancy;
    }

    public void setPredictedOccupancy(OccupancyStatus predictedOccupancy) {
        this.predictedOccupancy = predictedOccupancy;
    }

    public TimeIntervalBean getPredictedDepartureInterval() {
        return this.predictedDepartureInterval;
    }

    public void setPredictedDepartureInterval(TimeIntervalBean predictedDepartureInterval) {
        this.predictedDepartureInterval = predictedDepartureInterval;
    }

    public long getServiceDate() {
        return this.stopTimeInstance.getServiceDate();
    }

    public long getBestArrivalTime() {
        if (this.isPredictedArrivalTimeSet()) {
            return this.getPredictedArrivalTime();
        }
        return this.getScheduledArrivalTime();
    }

    public long getBestDepartureTime() {
        if (this.isPredictedDepartureTimeSet()) {
            return this.getPredictedDepartureTime();
        }
        return this.getScheduledDepartureTime();
    }

    public FrequencyEntry getFrequency() {
        return this.stopTimeInstance.getFrequency();
    }

    public FrequencyEntry getFrequencyLabel() {
        return this.stopTimeInstance.getFrequencyLabel();
    }

    public BlockTripEntry getBlockTrip() {
        return this.stopTimeInstance.getTrip();
    }

    public BlockTripInstance getBlockTripInstance() {
        return new BlockTripInstance(this.stopTimeInstance.getTrip(), this.stopTimeInstance.getState());
    }

    public StopEntry getStop() {
        return this.stopTimeInstance.getStop();
    }

    public String getScheduledTrack() {
        return this.scheduledTrack;
    }

    public void setScheduledTrack(String scheduledTrack) {
        this.scheduledTrack = scheduledTrack;
    }

    public String getActualTrack() {
        return this.actualTrack;
    }

    public void setActualTrack(String actualTrack) {
        this.actualTrack = actualTrack;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ArrivalAndDepartureInstance(");
        b.append("stop=");
        b.append(this.getStop().getId());
        b.append(",arrival=");
        b.append(_format.format(new Date(this.getBestArrivalTime())));
        b.append(",departure=");
        b.append(_format.format(new Date(this.getBestDepartureTime())));
        b.append(",block=" + this.getBlockTrip().getBlockConfiguration().getBlock().getId());
        b.append(")");
        return b.toString();
    }
}

