/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;

public class ScheduledBlockLocation {
    private BlockTripEntry activeTrip;
    private int scheduledTime;
    private CoordinatePoint location;
    private double orientation = Double.NaN;
    private double distanceAlongBlock = Double.NaN;
    private BlockStopTimeEntry closestStop;
    private int closestStopTimeOffset;
    private BlockStopTimeEntry nextStop;
    private int nextStopTimeOffset;
    private BlockStopTimeEntry previousStop;
    private int previousStopTimeOffset;
    private boolean inService;
    private int stopTimeIndex;

    public BlockTripEntry getActiveTrip() {
        return this.activeTrip;
    }

    public void setActiveTrip(BlockTripEntry activeTrip) {
        this.activeTrip = activeTrip;
    }

    public int getScheduledTime() {
        return this.scheduledTime;
    }

    public void setScheduledTime(int scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public CoordinatePoint getLocation() {
        return this.location;
    }

    public void setLocation(CoordinatePoint location) {
        this.location = location;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void setOrientation(double orientation) {
        this.orientation = orientation;
    }

    public double getDistanceAlongBlock() {
        return this.distanceAlongBlock;
    }

    public void setDistanceAlongBlock(double distanceAlongBlock) {
        this.distanceAlongBlock = distanceAlongBlock;
    }

    public BlockStopTimeEntry getClosestStop() {
        return this.closestStop;
    }

    public void setClosestStop(BlockStopTimeEntry closestStop) {
        this.closestStop = closestStop;
    }

    public int getClosestStopTimeOffset() {
        return this.closestStopTimeOffset;
    }

    public void setClosestStopTimeOffset(int closestStopTimeOffset) {
        this.closestStopTimeOffset = closestStopTimeOffset;
    }

    public BlockStopTimeEntry getNextStop() {
        return this.nextStop;
    }

    public void setNextStop(BlockStopTimeEntry nextStop) {
        this.nextStop = nextStop;
    }

    public int getNextStopTimeOffset() {
        return this.nextStopTimeOffset;
    }

    public void setNextStopTimeOffset(int nextStopTimeOffset) {
        this.nextStopTimeOffset = nextStopTimeOffset;
    }

    public BlockStopTimeEntry getPreviousStop() {
        return this.previousStop;
    }

    public void setPreviousStop(BlockStopTimeEntry previousStop) {
        this.previousStop = previousStop;
    }

    public int getPreviousStopTimeOffset() {
        return this.previousStopTimeOffset;
    }

    public void setPreviousStopTimeOffset(int previousStopTimeOffset) {
        this.previousStopTimeOffset = previousStopTimeOffset;
    }

    public boolean isInService() {
        return this.inService;
    }

    public void setInService(boolean inService) {
        this.inService = inService;
    }

    public int getStopTimeIndex() {
        return this.stopTimeIndex;
    }

    public void setStopTimeIndex(int stopTimeIndex) {
        this.stopTimeIndex = stopTimeIndex;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ScheduledBlockLocation(");
        b.append("activeTrip=");
        if (this.activeTrip != null) {
            b.append(this.activeTrip.getTrip().getId());
        } else {
            b.append("null");
        }
        int mins = this.scheduledTime / 60;
        b.append(" scheduledTime=").append(mins / 60).append(':').append(mins % 60);
        b.append(" distanceAlongBlock=").append(this.distanceAlongBlock);
        b.append(")");
        return b.toString();
    }
}

