/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.text.DateFormat;
import java.util.Date;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;

public class InstanceState {
    private static final DateFormat _serviceDateFormat = DateFormat.getDateTimeInstance(3, 3);
    private final long _serviceDate;
    private final FrequencyEntry _frequency;

    public InstanceState(long serviceDate) {
        this(serviceDate, null);
    }

    public InstanceState(long serviceDate, FrequencyEntry frequency) {
        this._serviceDate = serviceDate;
        this._frequency = frequency;
    }

    public long getServiceDate() {
        return this._serviceDate;
    }

    public FrequencyEntry getFrequency() {
        return this._frequency;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._frequency == null ? 0 : this._frequency.hashCode());
        result = 31 * result + (int)(this._serviceDate ^ this._serviceDate >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceState other = (InstanceState)obj;
        if (this._frequency == null ? other._frequency != null : !this._frequency.equals(other._frequency)) {
            return false;
        }
        return this._serviceDate == other._serviceDate;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("serviceDate=");
        b.append(_serviceDateFormat.format(new Date(this._serviceDate)));
        if (this._frequency != null) {
            b.append(" ");
            b.append(this._frequency);
        }
        return b.toString();
    }
}

