/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.util.AbstractList;
import java.util.List;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.transit_data_federation.impl.transit_graph.FrequencyBlockStopTimeEntryImpl;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.HasIndexedFrequencyBlockTrips;
import org.onebusaway.transit_data_federation.services.blocks.TransitTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyBlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.HasFrequencyBlockStopTimes;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;

@TransitTimeIndex
public class FrequencyStopTripIndex
implements HasIndexedFrequencyBlockTrips,
HasFrequencyBlockStopTimes {
    private final FrequencyBlockTripIndex _index;
    private final int _offset;
    private final FrequencyStopTimeList _frequencyStopTimes = new FrequencyStopTimeList();

    public FrequencyStopTripIndex(FrequencyBlockTripIndex index, int offset) {
        this._index = index;
        this._offset = offset;
    }

    public FrequencyBlockTripIndex getIndex() {
        return this._index;
    }

    public int getOffset() {
        return this._offset;
    }

    public ServiceIdActivation getServiceIds() {
        return this._index.getServiceIds();
    }

    public ServiceInterval getServiceInterval() {
        return this._index.getServiceIntervalBlock().getRange();
    }

    public int size() {
        return this._index.size();
    }

    @Override
    public int getStartTimeForIndex(int index) {
        return this._index.getStartTimeForIndex(index);
    }

    @Override
    public int getEndTimeForIndex(int index) {
        return this._index.getEndTimeForIndex(index);
    }

    @Override
    public List<FrequencyBlockStopTimeEntry> getFrequencyStopTimes() {
        return this._frequencyStopTimes;
    }

    private class FrequencyStopTimeList
    extends AbstractList<FrequencyBlockStopTimeEntry> {
        private FrequencyStopTimeList() {
        }

        @Override
        public int size() {
            return FrequencyStopTripIndex.this._index.size();
        }

        @Override
        public FrequencyBlockStopTimeEntry get(int index) {
            List<BlockTripEntry> trips = FrequencyStopTripIndex.this._index.getTrips();
            BlockTripEntry trip = trips.get(index);
            BlockStopTimeEntry blockStopTime = trip.getStopTimes().get(FrequencyStopTripIndex.this._offset);
            List<FrequencyEntry> frequencies = FrequencyStopTripIndex.this._index.getFrequencies();
            FrequencyEntry frequency = frequencies.get(index);
            return new FrequencyBlockStopTimeEntryImpl(blockStopTime, frequency);
        }
    }
}

