/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.io.Serializable;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;

public final class FrequencyServiceIntervalBlock
implements Serializable,
Comparable<FrequencyServiceIntervalBlock> {
    private static final long serialVersionUID = 1L;
    private final int[] startTimes;
    private final int[] endTimes;

    public FrequencyServiceIntervalBlock(int[] startTimes, int[] endTimes) {
        this.startTimes = startTimes;
        this.endTimes = endTimes;
        if (startTimes.length != endTimes.length) {
            throw new IllegalArgumentException("arrays must have same length");
        }
    }

    public int[] getStartTimes() {
        return this.startTimes;
    }

    public int[] getEndTimes() {
        return this.endTimes;
    }

    public ServiceInterval getRange() {
        int n = this.startTimes.length - 1;
        return new ServiceInterval(this.startTimes[0], this.startTimes[0], this.endTimes[n], this.endTimes[n]);
    }

    @Override
    public int compareTo(FrequencyServiceIntervalBlock o) {
        return this.startTimes[0] - o.startTimes[0];
    }
}

