/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripReference;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyServiceIntervalBlock;
import org.onebusaway.transit_data_federation.services.blocks.ReferencesLibrary;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;

public class FrequencyBlockTripIndexData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<BlockTripReference> _trips;
    private final List<FrequencyEntry> _frequencies;
    private final FrequencyServiceIntervalBlock _serviceIntervalBlock;

    public FrequencyBlockTripIndexData(List<BlockTripReference> trips, List<FrequencyEntry> frequencies, FrequencyServiceIntervalBlock serviceIntervalBlock) {
        this._trips = trips;
        this._frequencies = frequencies;
        this._serviceIntervalBlock = serviceIntervalBlock;
    }

    public List<BlockTripReference> getTrips() {
        return this._trips;
    }

    public List<FrequencyEntry> getFrequencies() {
        return this._frequencies;
    }

    public FrequencyServiceIntervalBlock getServiceIntervalBlock() {
        return this._serviceIntervalBlock;
    }

    public FrequencyBlockTripIndex createIndex(TransitGraphDao dao) {
        ArrayList<BlockTripEntry> trips = new ArrayList<BlockTripEntry>();
        for (int i = 0; i < this._trips.size(); ++i) {
            BlockTripReference tripReference = this._trips.get(i);
            BlockTripEntry blockTrip = ReferencesLibrary.getReferenceAsTrip(tripReference, dao);
            trips.add(blockTrip);
        }
        trips.trimToSize();
        return new FrequencyBlockTripIndex(trips, this._frequencies, this._serviceIntervalBlock);
    }
}

